<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transaktionType StructType
 * @subpackage Structs
 */
class TransaktionType extends AbstractStructBase
{
    /**
     * The preis
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - choice: preis | preisWaehrung | preisNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 7
     * - minInclusive: 0
     * - totalDigits: 15
     * @var float
     */
    public $preis;
    /**
     * The preisWaehrung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: preis | preisWaehrung | preisNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [A-Z]{2,2}[A-Za-z]{1,1}
     * @var string
     */
    public $preisWaehrung;
    /**
     * The preisNichtBezifferbar
     * Meta information extracted from the WSDL
     * - choice: preis | preisWaehrung | preisNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\EmptyElementType
     */
    public $preisNichtBezifferbar;
    /**
     * The volumen
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - choice: volumen | volumenWaehrung | volumenNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 4
     * - minInclusive: 0
     * - totalDigits: 19
     * @var float
     */
    public $volumen;
    /**
     * The volumenWaehrung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: volumen | volumenWaehrung | volumenNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [A-Z]{2,2}[A-Za-z]{1,1}
     * @var string
     */
    public $volumenWaehrung;
    /**
     * The volumenNichtBezifferbar
     * Meta information extracted from the WSDL
     * - choice: volumen | volumenWaehrung | volumenNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\EmptyElementType
     */
    public $volumenNichtBezifferbar;
    /**
     * Constructor method for transaktionType
     * @uses TransaktionType::setPreis()
     * @uses TransaktionType::setPreisWaehrung()
     * @uses TransaktionType::setPreisNichtBezifferbar()
     * @uses TransaktionType::setVolumen()
     * @uses TransaktionType::setVolumenWaehrung()
     * @uses TransaktionType::setVolumenNichtBezifferbar()
     * @param float $preis
     * @param string $preisWaehrung
     * @param \StructType\EmptyElementType $preisNichtBezifferbar
     * @param float $volumen
     * @param string $volumenWaehrung
     * @param \StructType\EmptyElementType $volumenNichtBezifferbar
     */
    public function __construct($preis = null, $preisWaehrung = null, \StructType\EmptyElementType $preisNichtBezifferbar = null, $volumen = null, $volumenWaehrung = null, \StructType\EmptyElementType $volumenNichtBezifferbar = null)
    {
        $this
            ->setPreis($preis)
            ->setPreisWaehrung($preisWaehrung)
            ->setPreisNichtBezifferbar($preisNichtBezifferbar)
            ->setVolumen($volumen)
            ->setVolumenWaehrung($volumenWaehrung)
            ->setVolumenNichtBezifferbar($volumenNichtBezifferbar);
    }
    /**
     * Get preis value
     * @return float|null
     */
    public function getPreis()
    {
        return isset($this->preis) ? $this->preis : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPreis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreis method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePreisForChoiceConstraintsFromSetPreis($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'preisWaehrung',
            'preisNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property preis can\'t be set as the property %s is already set. Only one property must be set among these properties: preis, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set preis value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $preis
     * @return \StructType\TransaktionType
     */
    public function setPreis($preis = null)
    {
        // validation for constraint: float
        if (!is_null($preis) && !(is_float($preis) || is_numeric($preis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preis, true), gettype($preis)), __LINE__);
        }
        // validation for constraint: choice(preis, preisWaehrung, preisNichtBezifferbar)
        if ('' !== ($preisChoiceErrorMessage = self::validatePreisForChoiceConstraintsFromSetPreis($preis))) {
            throw new \InvalidArgumentException($preisChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(7)
        if (!is_null($preis) && mb_strlen(mb_substr($preis, false !== mb_strpos($preis, '.') ? mb_strpos($preis, '.') + 1 : mb_strlen($preis))) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 7 fraction digits, %d given', var_export($preis, true), mb_strlen(mb_substr($preis, mb_strpos($preis, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($preis) && $preis < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($preis, true)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($preis) && mb_strlen(preg_replace('/(\D)/', '', $preis)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($preis, true), mb_strlen(preg_replace('/(\D)/', '', $preis))), __LINE__);
        }
        if (is_null($preis) || (is_array($preis) && empty($preis))) {
            unset($this->preis);
        } else {
            $this->preis = $preis;
        }
        return $this;
    }
    /**
     * Get preisWaehrung value
     * @return string|null
     */
    public function getPreisWaehrung()
    {
        return isset($this->preisWaehrung) ? $this->preisWaehrung : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPreisWaehrung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreisWaehrung method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePreisWaehrungForChoiceConstraintsFromSetPreisWaehrung($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'preis',
            'preisNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property preisWaehrung can\'t be set as the property %s is already set. Only one property must be set among these properties: preisWaehrung, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set preisWaehrung value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $preisWaehrung
     * @return \StructType\TransaktionType
     */
    public function setPreisWaehrung($preisWaehrung = null)
    {
        // validation for constraint: string
        if (!is_null($preisWaehrung) && !is_string($preisWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preisWaehrung, true), gettype($preisWaehrung)), __LINE__);
        }
        // validation for constraint: choice(preis, preisWaehrung, preisNichtBezifferbar)
        if ('' !== ($preisWaehrungChoiceErrorMessage = self::validatePreisWaehrungForChoiceConstraintsFromSetPreisWaehrung($preisWaehrung))) {
            throw new \InvalidArgumentException($preisWaehrungChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,2}[A-Za-z]{1,1})
        if (!is_null($preisWaehrung) && !preg_match('/[A-Z]{2,2}[A-Za-z]{1,1}/', $preisWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,2}[A-Za-z]{1,1}', var_export($preisWaehrung, true)), __LINE__);
        }
        if (is_null($preisWaehrung) || (is_array($preisWaehrung) && empty($preisWaehrung))) {
            unset($this->preisWaehrung);
        } else {
            $this->preisWaehrung = $preisWaehrung;
        }
        return $this;
    }
    /**
     * Get preisNichtBezifferbar value
     * @return \StructType\EmptyElementType|null
     */
    public function getPreisNichtBezifferbar()
    {
        return isset($this->preisNichtBezifferbar) ? $this->preisNichtBezifferbar : null;
    }
    /**
     * This method is responsible for validating the value passed to the setPreisNichtBezifferbar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPreisNichtBezifferbar method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePreisNichtBezifferbarForChoiceConstraintsFromSetPreisNichtBezifferbar($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'preis',
            'preisWaehrung',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property preisNichtBezifferbar can\'t be set as the property %s is already set. Only one property must be set among these properties: preisNichtBezifferbar, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set preisNichtBezifferbar value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmptyElementType $preisNichtBezifferbar
     * @return \StructType\TransaktionType
     */
    public function setPreisNichtBezifferbar(\StructType\EmptyElementType $preisNichtBezifferbar = null)
    {
        // validation for constraint: choice(preis, preisWaehrung, preisNichtBezifferbar)
        if ('' !== ($preisNichtBezifferbarChoiceErrorMessage = self::validatePreisNichtBezifferbarForChoiceConstraintsFromSetPreisNichtBezifferbar($preisNichtBezifferbar))) {
            throw new \InvalidArgumentException($preisNichtBezifferbarChoiceErrorMessage, __LINE__);
        }
        if (is_null($preisNichtBezifferbar) || (is_array($preisNichtBezifferbar) && empty($preisNichtBezifferbar))) {
            unset($this->preisNichtBezifferbar);
        } else {
            $this->preisNichtBezifferbar = $preisNichtBezifferbar;
        }
        return $this;
    }
    /**
     * Get volumen value
     * @return float|null
     */
    public function getVolumen()
    {
        return isset($this->volumen) ? $this->volumen : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVolumen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVolumen method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVolumenForChoiceConstraintsFromSetVolumen($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'volumenWaehrung',
            'volumenNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property volumen can\'t be set as the property %s is already set. Only one property must be set among these properties: volumen, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set volumen value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $volumen
     * @return \StructType\TransaktionType
     */
    public function setVolumen($volumen = null)
    {
        // validation for constraint: float
        if (!is_null($volumen) && !(is_float($volumen) || is_numeric($volumen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volumen, true), gettype($volumen)), __LINE__);
        }
        // validation for constraint: choice(volumen, volumenWaehrung, volumenNichtBezifferbar)
        if ('' !== ($volumenChoiceErrorMessage = self::validateVolumenForChoiceConstraintsFromSetVolumen($volumen))) {
            throw new \InvalidArgumentException($volumenChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($volumen) && mb_strlen(mb_substr($volumen, false !== mb_strpos($volumen, '.') ? mb_strpos($volumen, '.') + 1 : mb_strlen($volumen))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($volumen, true), mb_strlen(mb_substr($volumen, mb_strpos($volumen, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($volumen) && $volumen < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($volumen, true)), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($volumen) && mb_strlen(preg_replace('/(\D)/', '', $volumen)) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($volumen, true), mb_strlen(preg_replace('/(\D)/', '', $volumen))), __LINE__);
        }
        if (is_null($volumen) || (is_array($volumen) && empty($volumen))) {
            unset($this->volumen);
        } else {
            $this->volumen = $volumen;
        }
        return $this;
    }
    /**
     * Get volumenWaehrung value
     * @return string|null
     */
    public function getVolumenWaehrung()
    {
        return isset($this->volumenWaehrung) ? $this->volumenWaehrung : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVolumenWaehrung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVolumenWaehrung method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVolumenWaehrungForChoiceConstraintsFromSetVolumenWaehrung($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'volumen',
            'volumenNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property volumenWaehrung can\'t be set as the property %s is already set. Only one property must be set among these properties: volumenWaehrung, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set volumenWaehrung value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $volumenWaehrung
     * @return \StructType\TransaktionType
     */
    public function setVolumenWaehrung($volumenWaehrung = null)
    {
        // validation for constraint: string
        if (!is_null($volumenWaehrung) && !is_string($volumenWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($volumenWaehrung, true), gettype($volumenWaehrung)), __LINE__);
        }
        // validation for constraint: choice(volumen, volumenWaehrung, volumenNichtBezifferbar)
        if ('' !== ($volumenWaehrungChoiceErrorMessage = self::validateVolumenWaehrungForChoiceConstraintsFromSetVolumenWaehrung($volumenWaehrung))) {
            throw new \InvalidArgumentException($volumenWaehrungChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,2}[A-Za-z]{1,1})
        if (!is_null($volumenWaehrung) && !preg_match('/[A-Z]{2,2}[A-Za-z]{1,1}/', $volumenWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,2}[A-Za-z]{1,1}', var_export($volumenWaehrung, true)), __LINE__);
        }
        if (is_null($volumenWaehrung) || (is_array($volumenWaehrung) && empty($volumenWaehrung))) {
            unset($this->volumenWaehrung);
        } else {
            $this->volumenWaehrung = $volumenWaehrung;
        }
        return $this;
    }
    /**
     * Get volumenNichtBezifferbar value
     * @return \StructType\EmptyElementType|null
     */
    public function getVolumenNichtBezifferbar()
    {
        return isset($this->volumenNichtBezifferbar) ? $this->volumenNichtBezifferbar : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVolumenNichtBezifferbar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVolumenNichtBezifferbar method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVolumenNichtBezifferbarForChoiceConstraintsFromSetVolumenNichtBezifferbar($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'volumen',
            'volumenWaehrung',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property volumenNichtBezifferbar can\'t be set as the property %s is already set. Only one property must be set among these properties: volumenNichtBezifferbar, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set volumenNichtBezifferbar value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmptyElementType $volumenNichtBezifferbar
     * @return \StructType\TransaktionType
     */
    public function setVolumenNichtBezifferbar(\StructType\EmptyElementType $volumenNichtBezifferbar = null)
    {
        // validation for constraint: choice(volumen, volumenWaehrung, volumenNichtBezifferbar)
        if ('' !== ($volumenNichtBezifferbarChoiceErrorMessage = self::validateVolumenNichtBezifferbarForChoiceConstraintsFromSetVolumenNichtBezifferbar($volumenNichtBezifferbar))) {
            throw new \InvalidArgumentException($volumenNichtBezifferbarChoiceErrorMessage, __LINE__);
        }
        if (is_null($volumenNichtBezifferbar) || (is_array($volumenNichtBezifferbar) && empty($volumenNichtBezifferbar))) {
            unset($this->volumenNichtBezifferbar);
        } else {
            $this->volumenNichtBezifferbar = $volumenNichtBezifferbar;
        }
        return $this;
    }
}
