<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for submit StructType
 * @subpackage Structs
 */
class Submit extends AbstractStructBase
{
    /**
     * The ddMeldung
     * @var \StructType\DdMeldungType
     */
    public $ddMeldung;
    /**
     * The kundenreferenz
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9_/\-\+\(\)\.,]{1,20}
     * @var string
     */
    public $kundenreferenz;
    /**
     * Constructor method for submit
     * @uses Submit::setDdMeldung()
     * @uses Submit::setKundenreferenz()
     * @param \StructType\DdMeldungType $ddMeldung
     * @param string $kundenreferenz
     */
    public function __construct(\StructType\DdMeldungType $ddMeldung = null, $kundenreferenz = null)
    {
        $this
            ->setDdMeldung($ddMeldung)
            ->setKundenreferenz($kundenreferenz);
    }
    /**
     * Get ddMeldung value
     * @return \StructType\DdMeldungType|null
     */
    public function getDdMeldung()
    {
        return $this->ddMeldung;
    }
    /**
     * Set ddMeldung value
     * @param \StructType\DdMeldungType $ddMeldung
     * @return \StructType\Submit
     */
    public function setDdMeldung(\StructType\DdMeldungType $ddMeldung = null)
    {
        $this->ddMeldung = $ddMeldung;
        return $this;
    }
    /**
     * Get kundenreferenz value
     * @return string|null
     */
    public function getKundenreferenz()
    {
        return $this->kundenreferenz;
    }
    /**
     * Set kundenreferenz value
     * @param string $kundenreferenz
     * @return \StructType\Submit
     */
    public function setKundenreferenz($kundenreferenz = null)
    {
        // validation for constraint: string
        if (!is_null($kundenreferenz) && !is_string($kundenreferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kundenreferenz, true), gettype($kundenreferenz)), __LINE__);
        }
        // validation for constraint: pattern([A-Za-z0-9_/\-\+\(\)\.,]{1,20})
        if (!is_null($kundenreferenz) && !preg_match('/[A-Za-z0-9_\/\\-\\+\\(\\)\\.,]{1,20}/', $kundenreferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Za-z0-9_/\-\+\(\)\.,]{1,20}', var_export($kundenreferenz, true)), __LINE__);
        }
        $this->kundenreferenz = $kundenreferenz;
        return $this;
    }
}
