<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for geschaeftType StructType
 * @subpackage Structs
 */
class GeschaeftType extends AbstractStructBase
{
    /**
     * The finanzinstrument
     * @var \StructType\FinanzinstrumentType
     */
    public $finanzinstrument;
    /**
     * The artDesGeschaefts
     * @var \StructType\ArtDesGeschaeftsType
     */
    public $artDesGeschaefts;
    /**
     * The preisVolumen
     * @var \StructType\PreisVolumenType
     */
    public $preisVolumen;
    /**
     * The aggregierteInformationen
     * @var \StructType\AggregierteInformationenType
     */
    public $aggregierteInformationen;
    /**
     * The datumDesGeschaefts
     * Meta information extracted from the WSDL
     * - base: xsd:date
     * - pattern: [0-9]{4}\-.*
     * @var string
     */
    public $datumDesGeschaefts;
    /**
     * The ortDesGeschaefts
     * @var \StructType\OrtDesGeschaeftsType
     */
    public $ortDesGeschaefts;
    /**
     * Constructor method for geschaeftType
     * @uses GeschaeftType::setFinanzinstrument()
     * @uses GeschaeftType::setArtDesGeschaefts()
     * @uses GeschaeftType::setPreisVolumen()
     * @uses GeschaeftType::setAggregierteInformationen()
     * @uses GeschaeftType::setDatumDesGeschaefts()
     * @uses GeschaeftType::setOrtDesGeschaefts()
     * @param \StructType\FinanzinstrumentType $finanzinstrument
     * @param \StructType\ArtDesGeschaeftsType $artDesGeschaefts
     * @param \StructType\PreisVolumenType $preisVolumen
     * @param \StructType\AggregierteInformationenType $aggregierteInformationen
     * @param string $datumDesGeschaefts
     * @param \StructType\OrtDesGeschaeftsType $ortDesGeschaefts
     */
    public function __construct(\StructType\FinanzinstrumentType $finanzinstrument = null, \StructType\ArtDesGeschaeftsType $artDesGeschaefts = null, \StructType\PreisVolumenType $preisVolumen = null, \StructType\AggregierteInformationenType $aggregierteInformationen = null, $datumDesGeschaefts = null, \StructType\OrtDesGeschaeftsType $ortDesGeschaefts = null)
    {
        $this
            ->setFinanzinstrument($finanzinstrument)
            ->setArtDesGeschaefts($artDesGeschaefts)
            ->setPreisVolumen($preisVolumen)
            ->setAggregierteInformationen($aggregierteInformationen)
            ->setDatumDesGeschaefts($datumDesGeschaefts)
            ->setOrtDesGeschaefts($ortDesGeschaefts);
    }
    /**
     * Get finanzinstrument value
     * @return \StructType\FinanzinstrumentType|null
     */
    public function getFinanzinstrument()
    {
        return $this->finanzinstrument;
    }
    /**
     * Set finanzinstrument value
     * @param \StructType\FinanzinstrumentType $finanzinstrument
     * @return \StructType\GeschaeftType
     */
    public function setFinanzinstrument(\StructType\FinanzinstrumentType $finanzinstrument = null)
    {
        $this->finanzinstrument = $finanzinstrument;
        return $this;
    }
    /**
     * Get artDesGeschaefts value
     * @return \StructType\ArtDesGeschaeftsType|null
     */
    public function getArtDesGeschaefts()
    {
        return $this->artDesGeschaefts;
    }
    /**
     * Set artDesGeschaefts value
     * @param \StructType\ArtDesGeschaeftsType $artDesGeschaefts
     * @return \StructType\GeschaeftType
     */
    public function setArtDesGeschaefts(\StructType\ArtDesGeschaeftsType $artDesGeschaefts = null)
    {
        $this->artDesGeschaefts = $artDesGeschaefts;
        return $this;
    }
    /**
     * Get preisVolumen value
     * @return \StructType\PreisVolumenType|null
     */
    public function getPreisVolumen()
    {
        return $this->preisVolumen;
    }
    /**
     * Set preisVolumen value
     * @param \StructType\PreisVolumenType $preisVolumen
     * @return \StructType\GeschaeftType
     */
    public function setPreisVolumen(\StructType\PreisVolumenType $preisVolumen = null)
    {
        $this->preisVolumen = $preisVolumen;
        return $this;
    }
    /**
     * Get aggregierteInformationen value
     * @return \StructType\AggregierteInformationenType|null
     */
    public function getAggregierteInformationen()
    {
        return $this->aggregierteInformationen;
    }
    /**
     * Set aggregierteInformationen value
     * @param \StructType\AggregierteInformationenType $aggregierteInformationen
     * @return \StructType\GeschaeftType
     */
    public function setAggregierteInformationen(\StructType\AggregierteInformationenType $aggregierteInformationen = null)
    {
        $this->aggregierteInformationen = $aggregierteInformationen;
        return $this;
    }
    /**
     * Get datumDesGeschaefts value
     * @return string|null
     */
    public function getDatumDesGeschaefts()
    {
        return $this->datumDesGeschaefts;
    }
    /**
     * Set datumDesGeschaefts value
     * @param string $datumDesGeschaefts
     * @return \StructType\GeschaeftType
     */
    public function setDatumDesGeschaefts($datumDesGeschaefts = null)
    {
        // validation for constraint: string
        if (!is_null($datumDesGeschaefts) && !is_string($datumDesGeschaefts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumDesGeschaefts, true), gettype($datumDesGeschaefts)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}\-.*)
        if (!is_null($datumDesGeschaefts) && !preg_match('/[0-9]{4}\\-.*/', $datumDesGeschaefts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}\-.*', var_export($datumDesGeschaefts, true)), __LINE__);
        }
        $this->datumDesGeschaefts = $datumDesGeschaefts;
        return $this;
    }
    /**
     * Get ortDesGeschaefts value
     * @return \StructType\OrtDesGeschaeftsType|null
     */
    public function getOrtDesGeschaefts()
    {
        return $this->ortDesGeschaefts;
    }
    /**
     * Set ortDesGeschaefts value
     * @param \StructType\OrtDesGeschaeftsType $ortDesGeschaefts
     * @return \StructType\GeschaeftType
     */
    public function setOrtDesGeschaefts(\StructType\OrtDesGeschaeftsType $ortDesGeschaefts = null)
    {
        $this->ortDesGeschaefts = $ortDesGeschaefts;
        return $this;
    }
}
