<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for gaSonstigesType StructType
 * @subpackage Structs
 */
class GaSonstigesType extends AbstractStructBase
{
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 2000
     * - minLength: 1
     * @var string
     */
    public $beschreibung;
    /**
     * Constructor method for gaSonstigesType
     * @uses GaSonstigesType::setBeschreibung()
     * @param string $beschreibung
     */
    public function __construct($beschreibung = null)
    {
        $this
            ->setBeschreibung($beschreibung);
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \StructType\GaSonstigesType
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: maxLength(2000)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 2000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2000', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
}
