<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for finanzinstrumentType StructType
 * @subpackage Structs
 */
class FinanzinstrumentType extends AbstractStructBase
{
    /**
     * The isin
     * Meta information extracted from the WSDL
     * - documentation: Element im Format einer ISIN (Zwei Grossbuchstaben, gefolgt von 9 Grossbuchstaben oder Ziffern und einer Pruefziffer)
     * - base: xsd:string
     * - choice: isin | beschreibung
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - length: 12
     * - pattern: [A-Z]{2}[A-Z0-9]{9}[0-9]
     * @var string
     */
    public $isin;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - choice: isin | beschreibung
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $beschreibung;
    /**
     * The kennzeichnung
     * @var string
     */
    public $kennzeichnung;
    /**
     * Constructor method for finanzinstrumentType
     * @uses FinanzinstrumentType::setIsin()
     * @uses FinanzinstrumentType::setBeschreibung()
     * @uses FinanzinstrumentType::setKennzeichnung()
     * @param string $isin
     * @param string $beschreibung
     * @param string $kennzeichnung
     */
    public function __construct($isin = null, $beschreibung = null, $kennzeichnung = null)
    {
        $this
            ->setIsin($isin)
            ->setBeschreibung($beschreibung)
            ->setKennzeichnung($kennzeichnung);
    }
    /**
     * Get isin value
     * @return string|null
     */
    public function getIsin()
    {
        return isset($this->isin) ? $this->isin : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIsin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIsin method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIsinForChoiceConstraintsFromSetIsin($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'beschreibung',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property isin can\'t be set as the property %s is already set. Only one property must be set among these properties: isin, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set isin value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $isin
     * @return \StructType\FinanzinstrumentType
     */
    public function setIsin($isin = null)
    {
        // validation for constraint: string
        if (!is_null($isin) && !is_string($isin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isin, true), gettype($isin)), __LINE__);
        }
        // validation for constraint: choice(isin, beschreibung)
        if ('' !== ($isinChoiceErrorMessage = self::validateIsinForChoiceConstraintsFromSetIsin($isin))) {
            throw new \InvalidArgumentException($isinChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: length(12)
        if (!is_null($isin) && mb_strlen($isin) !== 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 12', mb_strlen($isin)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2}[A-Z0-9]{9}[0-9])
        if (!is_null($isin) && !preg_match('/[A-Z]{2}[A-Z0-9]{9}[0-9]/', $isin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}[A-Z0-9]{9}[0-9]', var_export($isin, true)), __LINE__);
        }
        if (is_null($isin) || (is_array($isin) && empty($isin))) {
            unset($this->isin);
        } else {
            $this->isin = $isin;
        }
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return isset($this->beschreibung) ? $this->beschreibung : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBeschreibungForChoiceConstraintsFromSetBeschreibung($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'isin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property beschreibung can\'t be set as the property %s is already set. Only one property must be set among these properties: beschreibung, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set beschreibung value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $beschreibung
     * @return \StructType\FinanzinstrumentType
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        // validation for constraint: choice(isin, beschreibung)
        if ('' !== ($beschreibungChoiceErrorMessage = self::validateBeschreibungForChoiceConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($beschreibung)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($beschreibung) && mb_strlen($beschreibung) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($beschreibung)), __LINE__);
        }
        if (is_null($beschreibung) || (is_array($beschreibung) && empty($beschreibung))) {
            unset($this->beschreibung);
        } else {
            $this->beschreibung = $beschreibung;
        }
        return $this;
    }
    /**
     * Get kennzeichnung value
     * @return string|null
     */
    public function getKennzeichnung()
    {
        return $this->kennzeichnung;
    }
    /**
     * Set kennzeichnung value
     * @uses \EnumType\FiKennzeichnungType::valueIsValid()
     * @uses \EnumType\FiKennzeichnungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kennzeichnung
     * @return \StructType\FinanzinstrumentType
     */
    public function setKennzeichnung($kennzeichnung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FiKennzeichnungType::valueIsValid($kennzeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FiKennzeichnungType', is_array($kennzeichnung) ? implode(', ', $kennzeichnung) : var_export($kennzeichnung, true), implode(', ', \EnumType\FiKennzeichnungType::getValidValues())), __LINE__);
        }
        $this->kennzeichnung = $kennzeichnung;
        return $this;
    }
}
