<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ausloeserType StructType
 * @subpackage Structs
 */
class AusloeserType extends AbstractStructBase
{
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $titel;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $vorname;
    /**
     * The nachname
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $nachname;
    /**
     * The position
     * @var \StructType\AusloeserPositionType
     */
    public $position;
    /**
     * Constructor method for ausloeserType
     * @uses AusloeserType::setTitel()
     * @uses AusloeserType::setVorname()
     * @uses AusloeserType::setNachname()
     * @uses AusloeserType::setPosition()
     * @param string $titel
     * @param string $vorname
     * @param string $nachname
     * @param \StructType\AusloeserPositionType $position
     */
    public function __construct($titel = null, $vorname = null, $nachname = null, \StructType\AusloeserPositionType $position = null)
    {
        $this
            ->setTitel($titel)
            ->setVorname($vorname)
            ->setNachname($nachname)
            ->setPosition($position);
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param string $titel
     * @return \StructType\AusloeserType
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($titel) && mb_strlen($titel) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($titel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titel) && mb_strlen($titel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titel)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\AusloeserType
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($vorname) && mb_strlen($vorname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($vorname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vorname) && mb_strlen($vorname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return $this->nachname;
    }
    /**
     * Set nachname value
     * @param string $nachname
     * @return \StructType\AusloeserType
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($nachname) && mb_strlen($nachname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($nachname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nachname) && mb_strlen($nachname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nachname)), __LINE__);
        }
        $this->nachname = $nachname;
        return $this;
    }
    /**
     * Get position value
     * @return \StructType\AusloeserPositionType|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param \StructType\AusloeserPositionType $position
     * @return \StructType\AusloeserType
     */
    public function setPosition(\StructType\AusloeserPositionType $position = null)
    {
        $this->position = $position;
        return $this;
    }
}
