<?php
/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'emptyElementType' => '\\StructType\\EmptyElementType',
            'ddMeldungType' => '\\StructType\\DdMeldungType',
            'ddOutType' => '\\StructType\\DdOutType',
            'personType' => '\\StructType\\PersonType',
            'personNameType' => '\\StructType\\PersonNameType',
            'grundDerMeldungType' => '\\StructType\\GrundDerMeldungType',
            'positionType' => '\\StructType\\PositionType',
            'positionSonstigeFuehrungspersonType' => '\\StructType\\PositionSonstigeFuehrungspersonType',
            'positionInEngerBeziehungType' => '\\StructType\\PositionInEngerBeziehungType',
            'ausloeserType' => '\\StructType\\AusloeserType',
            'ausloeserPositionType' => '\\StructType\\AusloeserPositionType',
            'artDerMeldungType' => '\\StructType\\ArtDerMeldungType',
            'berichtigungType' => '\\StructType\\BerichtigungType',
            'emittentType' => '\\StructType\\EmittentType',
            'geschaeftType' => '\\StructType\\GeschaeftType',
            'finanzinstrumentType' => '\\StructType\\FinanzinstrumentType',
            'artDesGeschaeftsType' => '\\StructType\\ArtDesGeschaeftsType',
            'gaSonstigesType' => '\\StructType\\GaSonstigesType',
            'preisVolumenType' => '\\StructType\\PreisVolumenType',
            'transaktionType' => '\\StructType\\TransaktionType',
            'aggregierteInformationenType' => '\\StructType\\AggregierteInformationenType',
            'ortDesGeschaeftsType' => '\\StructType\\OrtDesGeschaeftsType',
            'handelsplatzType' => '\\StructType\\HandelsplatzType',
            'submit' => '\\StructType\\Submit',
            'submitResponse' => '\\StructType\\SubmitResponse',
        );
    }
}
