<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetDeliveryAddressParams StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetDeliveryAddressParams
 * @subpackage Structs
 */
class SetDeliveryAddressParams extends AbstractStructBase
{
    /**
     * The OrderNumberList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $OrderNumberList;
    /**
     * The DeliveryAddressItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeliveryAddress
     */
    public $DeliveryAddressItem;
    /**
     * Constructor method for SetDeliveryAddressParams
     * @uses SetDeliveryAddressParams::setOrderNumberList()
     * @uses SetDeliveryAddressParams::setDeliveryAddressItem()
     * @param \ArrayType\ArrayOfstring $orderNumberList
     * @param \StructType\DeliveryAddress $deliveryAddressItem
     */
    public function __construct(\ArrayType\ArrayOfstring $orderNumberList = null, \StructType\DeliveryAddress $deliveryAddressItem = null)
    {
        $this
            ->setOrderNumberList($orderNumberList)
            ->setDeliveryAddressItem($deliveryAddressItem);
    }
    /**
     * Get OrderNumberList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOrderNumberList()
    {
        return isset($this->OrderNumberList) ? $this->OrderNumberList : null;
    }
    /**
     * Set OrderNumberList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $orderNumberList
     * @return \StructType\SetDeliveryAddressParams
     */
    public function setOrderNumberList(\ArrayType\ArrayOfstring $orderNumberList = null)
    {
        if (is_null($orderNumberList) || (is_array($orderNumberList) && empty($orderNumberList))) {
            unset($this->OrderNumberList);
        } else {
            $this->OrderNumberList = $orderNumberList;
        }
        return $this;
    }
    /**
     * Get DeliveryAddressItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeliveryAddress|null
     */
    public function getDeliveryAddressItem()
    {
        return isset($this->DeliveryAddressItem) ? $this->DeliveryAddressItem : null;
    }
    /**
     * Set DeliveryAddressItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DeliveryAddress $deliveryAddressItem
     * @return \StructType\SetDeliveryAddressParams
     */
    public function setDeliveryAddressItem(\StructType\DeliveryAddress $deliveryAddressItem = null)
    {
        if (is_null($deliveryAddressItem) || (is_array($deliveryAddressItem) && empty($deliveryAddressItem))) {
            unset($this->DeliveryAddressItem);
        } else {
            $this->DeliveryAddressItem = $deliveryAddressItem;
        }
        return $this;
    }
}
