<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceListError StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceListError
 * @subpackage Structs
 */
class PriceListError extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The err
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $err;
    /**
     * The prID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $prID;
    /**
     * Constructor method for PriceListError
     * @uses PriceListError::setCode()
     * @uses PriceListError::setErr()
     * @uses PriceListError::setPrID()
     * @param string $code
     * @param int $err
     * @param int $prID
     */
    public function __construct($code = null, $err = null, $prID = null)
    {
        $this
            ->setCode($code)
            ->setErr($err)
            ->setPrID($prID);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\PriceListError
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get err value
     * @return int|null
     */
    public function getErr()
    {
        return $this->err;
    }
    /**
     * Set err value
     * @param int $err
     * @return \StructType\PriceListError
     */
    public function setErr($err = null)
    {
        // validation for constraint: int
        if (!is_null($err) && !(is_int($err) || ctype_digit($err))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($err, true), gettype($err)), __LINE__);
        }
        $this->err = $err;
        return $this;
    }
    /**
     * Get prID value
     * @return int|null
     */
    public function getPrID()
    {
        return $this->prID;
    }
    /**
     * Set prID value
     * @param int $prID
     * @return \StructType\PriceListError
     */
    public function setPrID($prID = null)
    {
        // validation for constraint: int
        if (!is_null($prID) && !(is_int($prID) || ctype_digit($prID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prID, true), gettype($prID)), __LINE__);
        }
        $this->prID = $prID;
        return $this;
    }
}
