<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceList
 * @subpackage Structs
 */
class PriceList extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The prID
     * @var int
     */
    public $prID;
    /**
     * The price
     * @var float
     */
    public $price;
    /**
     * Constructor method for PriceList
     * @uses PriceList::setCode()
     * @uses PriceList::setPrID()
     * @uses PriceList::setPrice()
     * @param string $code
     * @param int $prID
     * @param float $price
     */
    public function __construct($code = null, $prID = null, $price = null)
    {
        $this
            ->setCode($code)
            ->setPrID($prID)
            ->setPrice($price);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\PriceList
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get prID value
     * @return int|null
     */
    public function getPrID()
    {
        return $this->prID;
    }
    /**
     * Set prID value
     * @param int $prID
     * @return \StructType\PriceList
     */
    public function setPrID($prID = null)
    {
        // validation for constraint: int
        if (!is_null($prID) && !(is_int($prID) || ctype_digit($prID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prID, true), gettype($prID)), __LINE__);
        }
        $this->prID = $prID;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\PriceList
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
}
