<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderProduct StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderProduct
 * @subpackage Structs
 */
class OrderProduct extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The fixPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $fixPrice;
    /**
     * The priceIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $priceIn;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The wrh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $wrh;
    /**
     * Constructor method for OrderProduct
     * @uses OrderProduct::setCode()
     * @uses OrderProduct::setFixPrice()
     * @uses OrderProduct::setPriceIn()
     * @uses OrderProduct::setQuantity()
     * @uses OrderProduct::setWrh()
     * @param string $code
     * @param bool $fixPrice
     * @param float $priceIn
     * @param int $quantity
     * @param int $wrh
     */
    public function __construct($code = null, $fixPrice = null, $priceIn = null, $quantity = null, $wrh = null)
    {
        $this
            ->setCode($code)
            ->setFixPrice($fixPrice)
            ->setPriceIn($priceIn)
            ->setQuantity($quantity)
            ->setWrh($wrh);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\OrderProduct
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get fixPrice value
     * @return bool|null
     */
    public function getFixPrice()
    {
        return $this->fixPrice;
    }
    /**
     * Set fixPrice value
     * @param bool $fixPrice
     * @return \StructType\OrderProduct
     */
    public function setFixPrice($fixPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($fixPrice) && !is_bool($fixPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fixPrice, true), gettype($fixPrice)), __LINE__);
        }
        $this->fixPrice = $fixPrice;
        return $this;
    }
    /**
     * Get priceIn value
     * @return float|null
     */
    public function getPriceIn()
    {
        return $this->priceIn;
    }
    /**
     * Set priceIn value
     * @param float $priceIn
     * @return \StructType\OrderProduct
     */
    public function setPriceIn($priceIn = null)
    {
        // validation for constraint: float
        if (!is_null($priceIn) && !(is_float($priceIn) || is_numeric($priceIn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceIn, true), gettype($priceIn)), __LINE__);
        }
        $this->priceIn = $priceIn;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\OrderProduct
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get wrh value
     * @return int|null
     */
    public function getWrh()
    {
        return $this->wrh;
    }
    /**
     * Set wrh value
     * @param int $wrh
     * @return \StructType\OrderProduct
     */
    public function setWrh($wrh = null)
    {
        // validation for constraint: int
        if (!is_null($wrh) && !(is_int($wrh) || ctype_digit($wrh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wrh, true), gettype($wrh)), __LINE__);
        }
        $this->wrh = $wrh;
        return $this;
    }
}
