<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsPriceRestFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GoodsPriceRestFilter
 * @subpackage Structs
 */
class GoodsPriceRestFilter extends AbstractStructBase
{
    /**
     * The code_list
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $code_list;
    /**
     * The wrh_list
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $wrh_list;
    /**
     * The include_paid_delivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $include_paid_delivery;
    /**
     * Constructor method for GoodsPriceRestFilter
     * @uses GoodsPriceRestFilter::setCode_list()
     * @uses GoodsPriceRestFilter::setWrh_list()
     * @uses GoodsPriceRestFilter::setInclude_paid_delivery()
     * @param \ArrayType\ArrayOfstring $code_list
     * @param \ArrayType\ArrayOfint $wrh_list
     * @param bool $include_paid_delivery
     */
    public function __construct(\ArrayType\ArrayOfstring $code_list = null, \ArrayType\ArrayOfint $wrh_list = null, $include_paid_delivery = null)
    {
        $this
            ->setCode_list($code_list)
            ->setWrh_list($wrh_list)
            ->setInclude_paid_delivery($include_paid_delivery);
    }
    /**
     * Get code_list value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getCode_list()
    {
        return $this->code_list;
    }
    /**
     * Set code_list value
     * @param \ArrayType\ArrayOfstring $code_list
     * @return \StructType\GoodsPriceRestFilter
     */
    public function setCode_list(\ArrayType\ArrayOfstring $code_list = null)
    {
        $this->code_list = $code_list;
        return $this;
    }
    /**
     * Get wrh_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getWrh_list()
    {
        return isset($this->wrh_list) ? $this->wrh_list : null;
    }
    /**
     * Set wrh_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $wrh_list
     * @return \StructType\GoodsPriceRestFilter
     */
    public function setWrh_list(\ArrayType\ArrayOfint $wrh_list = null)
    {
        if (is_null($wrh_list) || (is_array($wrh_list) && empty($wrh_list))) {
            unset($this->wrh_list);
        } else {
            $this->wrh_list = $wrh_list;
        }
        return $this;
    }
    /**
     * Get include_paid_delivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclude_paid_delivery()
    {
        return isset($this->include_paid_delivery) ? $this->include_paid_delivery : null;
    }
    /**
     * Set include_paid_delivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $include_paid_delivery
     * @return \StructType\GoodsPriceRestFilter
     */
    public function setInclude_paid_delivery($include_paid_delivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_paid_delivery) && !is_bool($include_paid_delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_paid_delivery, true), gettype($include_paid_delivery)), __LINE__);
        }
        if (is_null($include_paid_delivery) || (is_array($include_paid_delivery) && empty($include_paid_delivery))) {
            unset($this->include_paid_delivery);
        } else {
            $this->include_paid_delivery = $include_paid_delivery;
        }
        return $this;
    }
}
