<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tire ServiceType
 * @subpackage Services
 */
class Tire extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TireCalc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TireCalc $parameters
     * @return \StructType\TireCalcResponse|bool
     */
    public function TireCalc(\StructType\TireCalc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TireCalc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TireCalcResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
