<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRestList ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRestList
 * @subpackage Arrays
 */
class ArrayOfRestList extends AbstractStructArrayBase
{
    /**
     * The RestList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RestList[]
     */
    public $RestList;
    /**
     * Constructor method for ArrayOfRestList
     * @uses ArrayOfRestList::setRestList()
     * @param \StructType\RestList[] $restList
     */
    public function __construct(array $restList = array())
    {
        $this
            ->setRestList($restList);
    }
    /**
     * Get RestList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RestList[]|null
     */
    public function getRestList()
    {
        return isset($this->RestList) ? $this->RestList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRestList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestListForArrayConstraintsFromSetRestList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRestListRestListItem) {
            // validation for constraint: itemType
            if (!$arrayOfRestListRestListItem instanceof \StructType\RestList) {
                $invalidValues[] = is_object($arrayOfRestListRestListItem) ? get_class($arrayOfRestListRestListItem) : sprintf('%s(%s)', gettype($arrayOfRestListRestListItem), var_export($arrayOfRestListRestListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RestList property can only contain items of type \StructType\RestList, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RestList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RestList[] $restList
     * @return \ArrayType\ArrayOfRestList
     */
    public function setRestList(array $restList = array())
    {
        // validation for constraint: array
        if ('' !== ($restListArrayErrorMessage = self::validateRestListForArrayConstraintsFromSetRestList($restList))) {
            throw new \InvalidArgumentException($restListArrayErrorMessage, __LINE__);
        }
        if (is_null($restList) || (is_array($restList) && empty($restList))) {
            unset($this->RestList);
        } else {
            $this->RestList = $restList;
        }
        return $this;
    }
    /**
     * Add item to RestList value
     * @throws \InvalidArgumentException
     * @param \StructType\RestList $item
     * @return \ArrayType\ArrayOfRestList
     */
    public function addToRestList(\StructType\RestList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RestList) {
            throw new \InvalidArgumentException(sprintf('The RestList property can only contain items of type \StructType\RestList, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RestList[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RestList|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RestList|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RestList|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RestList|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RestList|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RestList
     */
    public function getAttributeName()
    {
        return 'RestList';
    }
}
