<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for yearAvto StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:yearAvto
 * @subpackage Structs
 */
class YearAvto extends AbstractStructBase
{
    /**
     * The year_begin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $year_begin;
    /**
     * The year_end
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $year_end;
    /**
     * Constructor method for yearAvto
     * @uses YearAvto::setYear_begin()
     * @uses YearAvto::setYear_end()
     * @param int $year_begin
     * @param int $year_end
     */
    public function __construct($year_begin = null, $year_end = null)
    {
        $this
            ->setYear_begin($year_begin)
            ->setYear_end($year_end);
    }
    /**
     * Get year_begin value
     * @return int|null
     */
    public function getYear_begin()
    {
        return $this->year_begin;
    }
    /**
     * Set year_begin value
     * @param int $year_begin
     * @return \StructType\YearAvto
     */
    public function setYear_begin($year_begin = null)
    {
        // validation for constraint: int
        if (!is_null($year_begin) && !(is_int($year_begin) || ctype_digit($year_begin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year_begin, true), gettype($year_begin)), __LINE__);
        }
        $this->year_begin = $year_begin;
        return $this;
    }
    /**
     * Get year_end value
     * @return int|null
     */
    public function getYear_end()
    {
        return $this->year_end;
    }
    /**
     * Set year_end value
     * @param int $year_end
     * @return \StructType\YearAvto
     */
    public function setYear_end($year_end = null)
    {
        // validation for constraint: int
        if (!is_null($year_end) && !(is_int($year_end) || ctype_digit($year_end))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year_end, true), gettype($year_end)), __LINE__);
        }
        $this->year_end = $year_end;
        return $this;
    }
}
