<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarehouseInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:WarehouseInfo
 * @subpackage Structs
 */
class WarehouseInfo extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $id;
    /**
     * The isPaidDelivery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPaidDelivery;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $key;
    /**
     * The logisticDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $logisticDays;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * Constructor method for WarehouseInfo
     * @uses WarehouseInfo::setId()
     * @uses WarehouseInfo::setIsPaidDelivery()
     * @uses WarehouseInfo::setKey()
     * @uses WarehouseInfo::setLogisticDays()
     * @uses WarehouseInfo::setName()
     * @param int $id
     * @param bool $isPaidDelivery
     * @param string $key
     * @param int $logisticDays
     * @param string $name
     */
    public function __construct($id = null, $isPaidDelivery = null, $key = null, $logisticDays = null, $name = null)
    {
        $this
            ->setId($id)
            ->setIsPaidDelivery($isPaidDelivery)
            ->setKey($key)
            ->setLogisticDays($logisticDays)
            ->setName($name);
    }
    /**
     * Get id value
     * @return int|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param int $id
     * @return \StructType\WarehouseInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get isPaidDelivery value
     * @return bool|null
     */
    public function getIsPaidDelivery()
    {
        return $this->isPaidDelivery;
    }
    /**
     * Set isPaidDelivery value
     * @param bool $isPaidDelivery
     * @return \StructType\WarehouseInfo
     */
    public function setIsPaidDelivery($isPaidDelivery = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaidDelivery) && !is_bool($isPaidDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaidDelivery, true), gettype($isPaidDelivery)), __LINE__);
        }
        $this->isPaidDelivery = $isPaidDelivery;
        return $this;
    }
    /**
     * Get key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKey()
    {
        return isset($this->key) ? $this->key : null;
    }
    /**
     * Set key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $key
     * @return \StructType\WarehouseInfo
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        if (is_null($key) || (is_array($key) && empty($key))) {
            unset($this->key);
        } else {
            $this->key = $key;
        }
        return $this;
    }
    /**
     * Get logisticDays value
     * @return int|null
     */
    public function getLogisticDays()
    {
        return $this->logisticDays;
    }
    /**
     * Set logisticDays value
     * @param int $logisticDays
     * @return \StructType\WarehouseInfo
     */
    public function setLogisticDays($logisticDays = null)
    {
        // validation for constraint: int
        if (!is_null($logisticDays) && !(is_int($logisticDays) || ctype_digit($logisticDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($logisticDays, true), gettype($logisticDays)), __LINE__);
        }
        $this->logisticDays = $logisticDays;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\WarehouseInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
}
