<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetMergeOrders StructType
 * @subpackage Structs
 */
class SetMergeOrders extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The orderNumber_list
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $orderNumber_list;
    /**
     * Constructor method for SetMergeOrders
     * @uses SetMergeOrders::setLogin()
     * @uses SetMergeOrders::setPassword()
     * @uses SetMergeOrders::setOrderNumber_list()
     * @param string $login
     * @param string $password
     * @param \ArrayType\ArrayOfstring $orderNumber_list
     */
    public function __construct($login = null, $password = null, \ArrayType\ArrayOfstring $orderNumber_list = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setOrderNumber_list($orderNumber_list);
    }
    /**
     * Get login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogin()
    {
        return isset($this->login) ? $this->login : null;
    }
    /**
     * Set login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $login
     * @return \StructType\SetMergeOrders
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->login);
        } else {
            $this->login = $login;
        }
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\SetMergeOrders
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get orderNumber_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOrderNumber_list()
    {
        return isset($this->orderNumber_list) ? $this->orderNumber_list : null;
    }
    /**
     * Set orderNumber_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $orderNumber_list
     * @return \StructType\SetMergeOrders
     */
    public function setOrderNumber_list(\ArrayType\ArrayOfstring $orderNumber_list = null)
    {
        if (is_null($orderNumber_list) || (is_array($orderNumber_list) && empty($orderNumber_list))) {
            unset($this->orderNumber_list);
        } else {
            $this->orderNumber_list = $orderNumber_list;
        }
        return $this;
    }
}
