<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleGoodContainer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SaleGoodContainer
 * @subpackage Structs
 */
class SaleGoodContainer extends AbstractStructBase
{
    /**
     * The artikul
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikul;
    /**
     * The nds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $nds;
    /**
     * The ndsIncludeInSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ndsIncludeInSum;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The sum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sum;
    /**
     * The wrh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $wrh;
    /**
     * Constructor method for SaleGoodContainer
     * @uses SaleGoodContainer::setArtikul()
     * @uses SaleGoodContainer::setNds()
     * @uses SaleGoodContainer::setNdsIncludeInSum()
     * @uses SaleGoodContainer::setOrderNumber()
     * @uses SaleGoodContainer::setPrice()
     * @uses SaleGoodContainer::setQuantity()
     * @uses SaleGoodContainer::setSum()
     * @uses SaleGoodContainer::setWrh()
     * @param string $artikul
     * @param float $nds
     * @param bool $ndsIncludeInSum
     * @param string $orderNumber
     * @param float $price
     * @param int $quantity
     * @param float $sum
     * @param int $wrh
     */
    public function __construct($artikul = null, $nds = null, $ndsIncludeInSum = null, $orderNumber = null, $price = null, $quantity = null, $sum = null, $wrh = null)
    {
        $this
            ->setArtikul($artikul)
            ->setNds($nds)
            ->setNdsIncludeInSum($ndsIncludeInSum)
            ->setOrderNumber($orderNumber)
            ->setPrice($price)
            ->setQuantity($quantity)
            ->setSum($sum)
            ->setWrh($wrh);
    }
    /**
     * Get artikul value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikul()
    {
        return isset($this->artikul) ? $this->artikul : null;
    }
    /**
     * Set artikul value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikul
     * @return \StructType\SaleGoodContainer
     */
    public function setArtikul($artikul = null)
    {
        // validation for constraint: string
        if (!is_null($artikul) && !is_string($artikul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikul, true), gettype($artikul)), __LINE__);
        }
        if (is_null($artikul) || (is_array($artikul) && empty($artikul))) {
            unset($this->artikul);
        } else {
            $this->artikul = $artikul;
        }
        return $this;
    }
    /**
     * Get nds value
     * @return float|null
     */
    public function getNds()
    {
        return $this->nds;
    }
    /**
     * Set nds value
     * @param float $nds
     * @return \StructType\SaleGoodContainer
     */
    public function setNds($nds = null)
    {
        // validation for constraint: float
        if (!is_null($nds) && !(is_float($nds) || is_numeric($nds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nds, true), gettype($nds)), __LINE__);
        }
        $this->nds = $nds;
        return $this;
    }
    /**
     * Get ndsIncludeInSum value
     * @return bool|null
     */
    public function getNdsIncludeInSum()
    {
        return $this->ndsIncludeInSum;
    }
    /**
     * Set ndsIncludeInSum value
     * @param bool $ndsIncludeInSum
     * @return \StructType\SaleGoodContainer
     */
    public function setNdsIncludeInSum($ndsIncludeInSum = null)
    {
        // validation for constraint: boolean
        if (!is_null($ndsIncludeInSum) && !is_bool($ndsIncludeInSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ndsIncludeInSum, true), gettype($ndsIncludeInSum)), __LINE__);
        }
        $this->ndsIncludeInSum = $ndsIncludeInSum;
        return $this;
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderNumber
     * @return \StructType\SaleGoodContainer
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\SaleGoodContainer
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\SaleGoodContainer
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->sum;
    }
    /**
     * Set sum value
     * @param float $sum
     * @return \StructType\SaleGoodContainer
     */
    public function setSum($sum = null)
    {
        // validation for constraint: float
        if (!is_null($sum) && !(is_float($sum) || is_numeric($sum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sum, true), gettype($sum)), __LINE__);
        }
        $this->sum = $sum;
        return $this;
    }
    /**
     * Get wrh value
     * @return int|null
     */
    public function getWrh()
    {
        return $this->wrh;
    }
    /**
     * Set wrh value
     * @param int $wrh
     * @return \StructType\SaleGoodContainer
     */
    public function setWrh($wrh = null)
    {
        // validation for constraint: int
        if (!is_null($wrh) && !(is_int($wrh) || ctype_digit($wrh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wrh, true), gettype($wrh)), __LINE__);
        }
        $this->wrh = $wrh;
        return $this;
    }
}
