<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleContainer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SaleContainer
 * @subpackage Structs
 */
class SaleContainer extends AbstractStructBase
{
    /**
     * The contractName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contractName;
    /**
     * The contractNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contractNumber;
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The dateSF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dateSF;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $number;
    /**
     * The numberSF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $numberSF;
    /**
     * The statusID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $statusID;
    /**
     * The sumRTU
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $sumRTU;
    /**
     * Constructor method for SaleContainer
     * @uses SaleContainer::setContractName()
     * @uses SaleContainer::setContractNumber()
     * @uses SaleContainer::setDate()
     * @uses SaleContainer::setDateSF()
     * @uses SaleContainer::setNumber()
     * @uses SaleContainer::setNumberSF()
     * @uses SaleContainer::setStatusID()
     * @uses SaleContainer::setSumRTU()
     * @param string $contractName
     * @param string $contractNumber
     * @param string $date
     * @param string $dateSF
     * @param string $number
     * @param string $numberSF
     * @param int $statusID
     * @param float $sumRTU
     */
    public function __construct($contractName = null, $contractNumber = null, $date = null, $dateSF = null, $number = null, $numberSF = null, $statusID = null, $sumRTU = null)
    {
        $this
            ->setContractName($contractName)
            ->setContractNumber($contractNumber)
            ->setDate($date)
            ->setDateSF($dateSF)
            ->setNumber($number)
            ->setNumberSF($numberSF)
            ->setStatusID($statusID)
            ->setSumRTU($sumRTU);
    }
    /**
     * Get contractName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractName()
    {
        return isset($this->contractName) ? $this->contractName : null;
    }
    /**
     * Set contractName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractName
     * @return \StructType\SaleContainer
     */
    public function setContractName($contractName = null)
    {
        // validation for constraint: string
        if (!is_null($contractName) && !is_string($contractName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractName, true), gettype($contractName)), __LINE__);
        }
        if (is_null($contractName) || (is_array($contractName) && empty($contractName))) {
            unset($this->contractName);
        } else {
            $this->contractName = $contractName;
        }
        return $this;
    }
    /**
     * Get contractNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractNumber()
    {
        return isset($this->contractNumber) ? $this->contractNumber : null;
    }
    /**
     * Set contractNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractNumber
     * @return \StructType\SaleContainer
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contractNumber, true), gettype($contractNumber)), __LINE__);
        }
        if (is_null($contractNumber) || (is_array($contractNumber) && empty($contractNumber))) {
            unset($this->contractNumber);
        } else {
            $this->contractNumber = $contractNumber;
        }
        return $this;
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\SaleContainer
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get dateSF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateSF()
    {
        return isset($this->dateSF) ? $this->dateSF : null;
    }
    /**
     * Set dateSF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateSF
     * @return \StructType\SaleContainer
     */
    public function setDateSF($dateSF = null)
    {
        // validation for constraint: string
        if (!is_null($dateSF) && !is_string($dateSF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateSF, true), gettype($dateSF)), __LINE__);
        }
        if (is_null($dateSF) || (is_array($dateSF) && empty($dateSF))) {
            unset($this->dateSF);
        } else {
            $this->dateSF = $dateSF;
        }
        return $this;
    }
    /**
     * Get number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->number) ? $this->number : null;
    }
    /**
     * Set number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\SaleContainer
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->number);
        } else {
            $this->number = $number;
        }
        return $this;
    }
    /**
     * Get numberSF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberSF()
    {
        return isset($this->numberSF) ? $this->numberSF : null;
    }
    /**
     * Set numberSF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberSF
     * @return \StructType\SaleContainer
     */
    public function setNumberSF($numberSF = null)
    {
        // validation for constraint: string
        if (!is_null($numberSF) && !is_string($numberSF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numberSF, true), gettype($numberSF)), __LINE__);
        }
        if (is_null($numberSF) || (is_array($numberSF) && empty($numberSF))) {
            unset($this->numberSF);
        } else {
            $this->numberSF = $numberSF;
        }
        return $this;
    }
    /**
     * Get statusID value
     * @return int|null
     */
    public function getStatusID()
    {
        return $this->statusID;
    }
    /**
     * Set statusID value
     * @param int $statusID
     * @return \StructType\SaleContainer
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->statusID = $statusID;
        return $this;
    }
    /**
     * Get sumRTU value
     * @return float|null
     */
    public function getSumRTU()
    {
        return $this->sumRTU;
    }
    /**
     * Set sumRTU value
     * @param float $sumRTU
     * @return \StructType\SaleContainer
     */
    public function setSumRTU($sumRTU = null)
    {
        // validation for constraint: float
        if (!is_null($sumRTU) && !(is_float($sumRTU) || is_numeric($sumRTU))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sumRTU, true), gettype($sumRTU)), __LINE__);
        }
        $this->sumRTU = $sumRTU;
        return $this;
    }
}
