<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result.PeriodContainer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Result.PeriodContainer
 * @subpackage Structs
 */
class Result_PeriodContainer extends AbstractStructBase
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The IntervalString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntervalString;
    /**
     * The IntervalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IntervalId;
    /**
     * The IntervalEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntervalEnd;
    /**
     * The IntervalStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntervalStart;
    /**
     * Constructor method for Result.PeriodContainer
     * @uses Result_PeriodContainer::setDate()
     * @uses Result_PeriodContainer::setIntervalString()
     * @uses Result_PeriodContainer::setIntervalId()
     * @uses Result_PeriodContainer::setIntervalEnd()
     * @uses Result_PeriodContainer::setIntervalStart()
     * @param string $date
     * @param string $intervalString
     * @param int $intervalId
     * @param string $intervalEnd
     * @param string $intervalStart
     */
    public function __construct($date = null, $intervalString = null, $intervalId = null, $intervalEnd = null, $intervalStart = null)
    {
        $this
            ->setDate($date)
            ->setIntervalString($intervalString)
            ->setIntervalId($intervalId)
            ->setIntervalEnd($intervalEnd)
            ->setIntervalStart($intervalStart);
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\Result_PeriodContainer
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get IntervalString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntervalString()
    {
        return isset($this->IntervalString) ? $this->IntervalString : null;
    }
    /**
     * Set IntervalString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intervalString
     * @return \StructType\Result_PeriodContainer
     */
    public function setIntervalString($intervalString = null)
    {
        // validation for constraint: string
        if (!is_null($intervalString) && !is_string($intervalString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalString, true), gettype($intervalString)), __LINE__);
        }
        if (is_null($intervalString) || (is_array($intervalString) && empty($intervalString))) {
            unset($this->IntervalString);
        } else {
            $this->IntervalString = $intervalString;
        }
        return $this;
    }
    /**
     * Get IntervalId value
     * @return int|null
     */
    public function getIntervalId()
    {
        return $this->IntervalId;
    }
    /**
     * Set IntervalId value
     * @param int $intervalId
     * @return \StructType\Result_PeriodContainer
     */
    public function setIntervalId($intervalId = null)
    {
        // validation for constraint: int
        if (!is_null($intervalId) && !(is_int($intervalId) || ctype_digit($intervalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intervalId, true), gettype($intervalId)), __LINE__);
        }
        $this->IntervalId = $intervalId;
        return $this;
    }
    /**
     * Get IntervalEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntervalEnd()
    {
        return isset($this->IntervalEnd) ? $this->IntervalEnd : null;
    }
    /**
     * Set IntervalEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intervalEnd
     * @return \StructType\Result_PeriodContainer
     */
    public function setIntervalEnd($intervalEnd = null)
    {
        // validation for constraint: string
        if (!is_null($intervalEnd) && !is_string($intervalEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalEnd, true), gettype($intervalEnd)), __LINE__);
        }
        if (is_null($intervalEnd) || (is_array($intervalEnd) && empty($intervalEnd))) {
            unset($this->IntervalEnd);
        } else {
            $this->IntervalEnd = $intervalEnd;
        }
        return $this;
    }
    /**
     * Get IntervalStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntervalStart()
    {
        return isset($this->IntervalStart) ? $this->IntervalStart : null;
    }
    /**
     * Set IntervalStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intervalStart
     * @return \StructType\Result_PeriodContainer
     */
    public function setIntervalStart($intervalStart = null)
    {
        // validation for constraint: string
        if (!is_null($intervalStart) && !is_string($intervalStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalStart, true), gettype($intervalStart)), __LINE__);
        }
        if (is_null($intervalStart) || (is_array($intervalStart) && empty($intervalStart))) {
            unset($this->IntervalStart);
        } else {
            $this->IntervalStart = $intervalStart;
        }
        return $this;
    }
}
