<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RestList
 * @subpackage Structs
 */
class RestList extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The rest
     * @var int
     */
    public $rest;
    /**
     * The wrh
     * @var int
     */
    public $wrh;
    /**
     * Constructor method for RestList
     * @uses RestList::setCode()
     * @uses RestList::setRest()
     * @uses RestList::setWrh()
     * @param string $code
     * @param int $rest
     * @param int $wrh
     */
    public function __construct($code = null, $rest = null, $wrh = null)
    {
        $this
            ->setCode($code)
            ->setRest($rest)
            ->setWrh($wrh);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\RestList
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get rest value
     * @return int|null
     */
    public function getRest()
    {
        return $this->rest;
    }
    /**
     * Set rest value
     * @param int $rest
     * @return \StructType\RestList
     */
    public function setRest($rest = null)
    {
        // validation for constraint: int
        if (!is_null($rest) && !(is_int($rest) || ctype_digit($rest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rest, true), gettype($rest)), __LINE__);
        }
        $this->rest = $rest;
        return $this;
    }
    /**
     * Get wrh value
     * @return int|null
     */
    public function getWrh()
    {
        return $this->wrh;
    }
    /**
     * Set wrh value
     * @param int $wrh
     * @return \StructType\RestList
     */
    public function setWrh($wrh = null)
    {
        // validation for constraint: int
        if (!is_null($wrh) && !(is_int($wrh) || ctype_digit($wrh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wrh, true), gettype($wrh)), __LINE__);
        }
        $this->wrh = $wrh;
        return $this;
    }
}
