<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for params StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:params
 * @subpackage Structs
 */
class Params extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The isWarehouseReplenishment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isWarehouseReplenishment;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $number;
    /**
     * The warehouse
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $warehouse;
    /**
     * Constructor method for params
     * @uses Params::setDate()
     * @uses Params::setIsWarehouseReplenishment()
     * @uses Params::setNumber()
     * @uses Params::setWarehouse()
     * @param string $date
     * @param bool $isWarehouseReplenishment
     * @param string $number
     * @param int $warehouse
     */
    public function __construct($date = null, $isWarehouseReplenishment = null, $number = null, $warehouse = null)
    {
        $this
            ->setDate($date)
            ->setIsWarehouseReplenishment($isWarehouseReplenishment)
            ->setNumber($number)
            ->setWarehouse($warehouse);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\Params
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get isWarehouseReplenishment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWarehouseReplenishment()
    {
        return isset($this->isWarehouseReplenishment) ? $this->isWarehouseReplenishment : null;
    }
    /**
     * Set isWarehouseReplenishment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWarehouseReplenishment
     * @return \StructType\Params
     */
    public function setIsWarehouseReplenishment($isWarehouseReplenishment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWarehouseReplenishment) && !is_bool($isWarehouseReplenishment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWarehouseReplenishment, true), gettype($isWarehouseReplenishment)), __LINE__);
        }
        if (is_null($isWarehouseReplenishment) || (is_array($isWarehouseReplenishment) && empty($isWarehouseReplenishment))) {
            unset($this->isWarehouseReplenishment);
        } else {
            $this->isWarehouseReplenishment = $isWarehouseReplenishment;
        }
        return $this;
    }
    /**
     * Get number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->number) ? $this->number : null;
    }
    /**
     * Set number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\Params
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->number);
        } else {
            $this->number = $number;
        }
        return $this;
    }
    /**
     * Get warehouse value
     * @return int|null
     */
    public function getWarehouse()
    {
        return $this->warehouse;
    }
    /**
     * Set warehouse value
     * @param int $warehouse
     * @return \StructType\Params
     */
    public function setWarehouse($warehouse = null)
    {
        // validation for constraint: int
        if (!is_null($warehouse) && !(is_int($warehouse) || ctype_digit($warehouse))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($warehouse, true), gettype($warehouse)), __LINE__);
        }
        $this->warehouse = $warehouse;
        return $this;
    }
}
