<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Order
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The base_order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BaseOrder
     */
    public $base_order;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $comment;
    /**
     * The comment_cc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $comment_cc;
    /**
     * The createBonus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $createBonus;
    /**
     * The customerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $customerId;
    /**
     * The deliveryInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeliveryInfoContainer
     */
    public $deliveryInfo;
    /**
     * The is_test
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $is_test;
    /**
     * The product_list
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfOrderProduct
     */
    public $product_list;
    /**
     * The skip_error_61
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $skip_error_61;
    /**
     * The useBonus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useBonus;
    /**
     * Constructor method for Order
     * @uses Order::setBase_order()
     * @uses Order::setComment()
     * @uses Order::setComment_cc()
     * @uses Order::setCreateBonus()
     * @uses Order::setCustomerId()
     * @uses Order::setDeliveryInfo()
     * @uses Order::setIs_test()
     * @uses Order::setProduct_list()
     * @uses Order::setSkip_error_61()
     * @uses Order::setUseBonus()
     * @param \StructType\BaseOrder $base_order
     * @param string $comment
     * @param string $comment_cc
     * @param bool $createBonus
     * @param int $customerId
     * @param \StructType\DeliveryInfoContainer $deliveryInfo
     * @param bool $is_test
     * @param \ArrayType\ArrayOfOrderProduct $product_list
     * @param bool $skip_error_61
     * @param bool $useBonus
     */
    public function __construct(\StructType\BaseOrder $base_order = null, $comment = null, $comment_cc = null, $createBonus = null, $customerId = null, \StructType\DeliveryInfoContainer $deliveryInfo = null, $is_test = null, \ArrayType\ArrayOfOrderProduct $product_list = null, $skip_error_61 = null, $useBonus = null)
    {
        $this
            ->setBase_order($base_order)
            ->setComment($comment)
            ->setComment_cc($comment_cc)
            ->setCreateBonus($createBonus)
            ->setCustomerId($customerId)
            ->setDeliveryInfo($deliveryInfo)
            ->setIs_test($is_test)
            ->setProduct_list($product_list)
            ->setSkip_error_61($skip_error_61)
            ->setUseBonus($useBonus);
    }
    /**
     * Get base_order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BaseOrder|null
     */
    public function getBase_order()
    {
        return isset($this->base_order) ? $this->base_order : null;
    }
    /**
     * Set base_order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\BaseOrder $base_order
     * @return \StructType\Order
     */
    public function setBase_order(\StructType\BaseOrder $base_order = null)
    {
        if (is_null($base_order) || (is_array($base_order) && empty($base_order))) {
            unset($this->base_order);
        } else {
            $this->base_order = $base_order;
        }
        return $this;
    }
    /**
     * Get comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->comment) ? $this->comment : null;
    }
    /**
     * Set comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \StructType\Order
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->comment);
        } else {
            $this->comment = $comment;
        }
        return $this;
    }
    /**
     * Get comment_cc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment_cc()
    {
        return isset($this->comment_cc) ? $this->comment_cc : null;
    }
    /**
     * Set comment_cc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment_cc
     * @return \StructType\Order
     */
    public function setComment_cc($comment_cc = null)
    {
        // validation for constraint: string
        if (!is_null($comment_cc) && !is_string($comment_cc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment_cc, true), gettype($comment_cc)), __LINE__);
        }
        if (is_null($comment_cc) || (is_array($comment_cc) && empty($comment_cc))) {
            unset($this->comment_cc);
        } else {
            $this->comment_cc = $comment_cc;
        }
        return $this;
    }
    /**
     * Get createBonus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCreateBonus()
    {
        return isset($this->createBonus) ? $this->createBonus : null;
    }
    /**
     * Set createBonus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $createBonus
     * @return \StructType\Order
     */
    public function setCreateBonus($createBonus = null)
    {
        // validation for constraint: boolean
        if (!is_null($createBonus) && !is_bool($createBonus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($createBonus, true), gettype($createBonus)), __LINE__);
        }
        if (is_null($createBonus) || (is_array($createBonus) && empty($createBonus))) {
            unset($this->createBonus);
        } else {
            $this->createBonus = $createBonus;
        }
        return $this;
    }
    /**
     * Get customerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCustomerId()
    {
        return isset($this->customerId) ? $this->customerId : null;
    }
    /**
     * Set customerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $customerId
     * @return \StructType\Order
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: int
        if (!is_null($customerId) && !(is_int($customerId) || ctype_digit($customerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->customerId);
        } else {
            $this->customerId = $customerId;
        }
        return $this;
    }
    /**
     * Get deliveryInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeliveryInfoContainer|null
     */
    public function getDeliveryInfo()
    {
        return isset($this->deliveryInfo) ? $this->deliveryInfo : null;
    }
    /**
     * Set deliveryInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DeliveryInfoContainer $deliveryInfo
     * @return \StructType\Order
     */
    public function setDeliveryInfo(\StructType\DeliveryInfoContainer $deliveryInfo = null)
    {
        if (is_null($deliveryInfo) || (is_array($deliveryInfo) && empty($deliveryInfo))) {
            unset($this->deliveryInfo);
        } else {
            $this->deliveryInfo = $deliveryInfo;
        }
        return $this;
    }
    /**
     * Get is_test value
     * @return bool|null
     */
    public function getIs_test()
    {
        return $this->is_test;
    }
    /**
     * Set is_test value
     * @param bool $is_test
     * @return \StructType\Order
     */
    public function setIs_test($is_test = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_test) && !is_bool($is_test)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_test, true), gettype($is_test)), __LINE__);
        }
        $this->is_test = $is_test;
        return $this;
    }
    /**
     * Get product_list value
     * @return \ArrayType\ArrayOfOrderProduct|null
     */
    public function getProduct_list()
    {
        return $this->product_list;
    }
    /**
     * Set product_list value
     * @param \ArrayType\ArrayOfOrderProduct $product_list
     * @return \StructType\Order
     */
    public function setProduct_list(\ArrayType\ArrayOfOrderProduct $product_list = null)
    {
        $this->product_list = $product_list;
        return $this;
    }
    /**
     * Get skip_error value
     * @return skip_error
     */
    public function getSkip_error_61()
    {
        return $this->skip_error_61;
    }
    /**
     * Set skip_error value
     * @param skip_error $skip_error
     * @return \StructType\Order
     */
    public function setSkip_error_61($skip_error_61 = null)
    {
        // validation for constraint: boolean
        if (!is_null($skip_error_61) && !is_bool($skip_error_61)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skip_error_61, true), gettype($skip_error_61)), __LINE__);
        }
        $this->skip_error_61 = $skip_error_61;
        return $this;
    }
    /**
     * Get useBonus value
     * @return bool|null
     */
    public function getUseBonus()
    {
        return $this->useBonus;
    }
    /**
     * Set useBonus value
     * @param bool $useBonus
     * @return \StructType\Order
     */
    public function setUseBonus($useBonus = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBonus) && !is_bool($useBonus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useBonus, true), gettype($useBonus)), __LINE__);
        }
        $this->useBonus = $useBonus;
        return $this;
    }
}
