<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for movementInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:movementInfo
 * @subpackage Structs
 */
class MovementInfo extends AbstractStructBase
{
    /**
     * The date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $date;
    /**
     * The idStoreFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idStoreFrom;
    /**
     * The idStoreTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idStoreTo;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $number;
    /**
     * The statusID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $statusID;
    /**
     * Constructor method for movementInfo
     * @uses MovementInfo::setDate()
     * @uses MovementInfo::setIdStoreFrom()
     * @uses MovementInfo::setIdStoreTo()
     * @uses MovementInfo::setNumber()
     * @uses MovementInfo::setStatusID()
     * @param string $date
     * @param int $idStoreFrom
     * @param int $idStoreTo
     * @param string $number
     * @param int $statusID
     */
    public function __construct($date = null, $idStoreFrom = null, $idStoreTo = null, $number = null, $statusID = null)
    {
        $this
            ->setDate($date)
            ->setIdStoreFrom($idStoreFrom)
            ->setIdStoreTo($idStoreTo)
            ->setNumber($number)
            ->setStatusID($statusID);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \StructType\MovementInfo
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get idStoreFrom value
     * @return int|null
     */
    public function getIdStoreFrom()
    {
        return $this->idStoreFrom;
    }
    /**
     * Set idStoreFrom value
     * @param int $idStoreFrom
     * @return \StructType\MovementInfo
     */
    public function setIdStoreFrom($idStoreFrom = null)
    {
        // validation for constraint: int
        if (!is_null($idStoreFrom) && !(is_int($idStoreFrom) || ctype_digit($idStoreFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStoreFrom, true), gettype($idStoreFrom)), __LINE__);
        }
        $this->idStoreFrom = $idStoreFrom;
        return $this;
    }
    /**
     * Get idStoreTo value
     * @return int|null
     */
    public function getIdStoreTo()
    {
        return $this->idStoreTo;
    }
    /**
     * Set idStoreTo value
     * @param int $idStoreTo
     * @return \StructType\MovementInfo
     */
    public function setIdStoreTo($idStoreTo = null)
    {
        // validation for constraint: int
        if (!is_null($idStoreTo) && !(is_int($idStoreTo) || ctype_digit($idStoreTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStoreTo, true), gettype($idStoreTo)), __LINE__);
        }
        $this->idStoreTo = $idStoreTo;
        return $this;
    }
    /**
     * Get number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->number) ? $this->number : null;
    }
    /**
     * Set number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\MovementInfo
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->number);
        } else {
            $this->number = $number;
        }
        return $this;
    }
    /**
     * Get statusID value
     * @return int|null
     */
    public function getStatusID()
    {
        return $this->statusID;
    }
    /**
     * Set statusID value
     * @param int $statusID
     * @return \StructType\MovementInfo
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->statusID = $statusID;
        return $this;
    }
}
