<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Goods StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Goods
 * @subpackage Structs
 */
class Goods extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The priceIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $priceIn;
    /**
     * The price_rozn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price_rozn;
    /**
     * The price_satellite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price_satellite;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The wrh
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $wrh;
    /**
     * Constructor method for Goods
     * @uses Goods::setCode()
     * @uses Goods::setPrice()
     * @uses Goods::setPriceIn()
     * @uses Goods::setPrice_rozn()
     * @uses Goods::setPrice_satellite()
     * @uses Goods::setQuantity()
     * @uses Goods::setWrh()
     * @param string $code
     * @param float $price
     * @param float $priceIn
     * @param float $price_rozn
     * @param float $price_satellite
     * @param int $quantity
     * @param int $wrh
     */
    public function __construct($code = null, $price = null, $priceIn = null, $price_rozn = null, $price_satellite = null, $quantity = null, $wrh = null)
    {
        $this
            ->setCode($code)
            ->setPrice($price)
            ->setPriceIn($priceIn)
            ->setPrice_rozn($price_rozn)
            ->setPrice_satellite($price_satellite)
            ->setQuantity($quantity)
            ->setWrh($wrh);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\Goods
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\Goods
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get priceIn value
     * @return float|null
     */
    public function getPriceIn()
    {
        return $this->priceIn;
    }
    /**
     * Set priceIn value
     * @param float $priceIn
     * @return \StructType\Goods
     */
    public function setPriceIn($priceIn = null)
    {
        // validation for constraint: float
        if (!is_null($priceIn) && !(is_float($priceIn) || is_numeric($priceIn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceIn, true), gettype($priceIn)), __LINE__);
        }
        $this->priceIn = $priceIn;
        return $this;
    }
    /**
     * Get price_rozn value
     * @return float|null
     */
    public function getPrice_rozn()
    {
        return $this->price_rozn;
    }
    /**
     * Set price_rozn value
     * @param float $price_rozn
     * @return \StructType\Goods
     */
    public function setPrice_rozn($price_rozn = null)
    {
        // validation for constraint: float
        if (!is_null($price_rozn) && !(is_float($price_rozn) || is_numeric($price_rozn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price_rozn, true), gettype($price_rozn)), __LINE__);
        }
        $this->price_rozn = $price_rozn;
        return $this;
    }
    /**
     * Get price_satellite value
     * @return float|null
     */
    public function getPrice_satellite()
    {
        return $this->price_satellite;
    }
    /**
     * Set price_satellite value
     * @param float $price_satellite
     * @return \StructType\Goods
     */
    public function setPrice_satellite($price_satellite = null)
    {
        // validation for constraint: float
        if (!is_null($price_satellite) && !(is_float($price_satellite) || is_numeric($price_satellite))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price_satellite, true), gettype($price_satellite)), __LINE__);
        }
        $this->price_satellite = $price_satellite;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\Goods
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get wrh value
     * @return int|null
     */
    public function getWrh()
    {
        return $this->wrh;
    }
    /**
     * Set wrh value
     * @param int $wrh
     * @return \StructType\Goods
     */
    public function setWrh($wrh = null)
    {
        // validation for constraint: int
        if (!is_null($wrh) && !(is_int($wrh) || ctype_digit($wrh))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wrh, true), gettype($wrh)), __LINE__);
        }
        $this->wrh = $wrh;
        return $this;
    }
}
