<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetOrderStatusResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetOrderStatusResult
 * @subpackage Structs
 */
class GetOrderStatusResult extends AbstractStructBase
{
    /**
     * The errorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $errorCode;
    /**
     * The hasItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasItem;
    /**
     * The hasMerged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $hasMerged;
    /**
     * The mergedTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mergedTo;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parent;
    /**
     * The statusID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $statusID;
    /**
     * The success
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $success;
    /**
     * Constructor method for GetOrderStatusResult
     * @uses GetOrderStatusResult::setErrorCode()
     * @uses GetOrderStatusResult::setHasItem()
     * @uses GetOrderStatusResult::setHasMerged()
     * @uses GetOrderStatusResult::setMergedTo()
     * @uses GetOrderStatusResult::setOrderNumber()
     * @uses GetOrderStatusResult::setParent()
     * @uses GetOrderStatusResult::setStatusID()
     * @uses GetOrderStatusResult::setSuccess()
     * @param int $errorCode
     * @param bool $hasItem
     * @param bool $hasMerged
     * @param string $mergedTo
     * @param string $orderNumber
     * @param string $parent
     * @param int $statusID
     * @param bool $success
     */
    public function __construct($errorCode = null, $hasItem = null, $hasMerged = null, $mergedTo = null, $orderNumber = null, $parent = null, $statusID = null, $success = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setHasItem($hasItem)
            ->setHasMerged($hasMerged)
            ->setMergedTo($mergedTo)
            ->setOrderNumber($orderNumber)
            ->setParent($parent)
            ->setStatusID($statusID)
            ->setSuccess($success);
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \StructType\GetOrderStatusResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !(is_int($errorCode) || ctype_digit($errorCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get hasItem value
     * @return bool|null
     */
    public function getHasItem()
    {
        return $this->hasItem;
    }
    /**
     * Set hasItem value
     * @param bool $hasItem
     * @return \StructType\GetOrderStatusResult
     */
    public function setHasItem($hasItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasItem) && !is_bool($hasItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasItem, true), gettype($hasItem)), __LINE__);
        }
        $this->hasItem = $hasItem;
        return $this;
    }
    /**
     * Get hasMerged value
     * @return bool|null
     */
    public function getHasMerged()
    {
        return $this->hasMerged;
    }
    /**
     * Set hasMerged value
     * @param bool $hasMerged
     * @return \StructType\GetOrderStatusResult
     */
    public function setHasMerged($hasMerged = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMerged) && !is_bool($hasMerged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMerged, true), gettype($hasMerged)), __LINE__);
        }
        $this->hasMerged = $hasMerged;
        return $this;
    }
    /**
     * Get mergedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMergedTo()
    {
        return isset($this->mergedTo) ? $this->mergedTo : null;
    }
    /**
     * Set mergedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mergedTo
     * @return \StructType\GetOrderStatusResult
     */
    public function setMergedTo($mergedTo = null)
    {
        // validation for constraint: string
        if (!is_null($mergedTo) && !is_string($mergedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mergedTo, true), gettype($mergedTo)), __LINE__);
        }
        if (is_null($mergedTo) || (is_array($mergedTo) && empty($mergedTo))) {
            unset($this->mergedTo);
        } else {
            $this->mergedTo = $mergedTo;
        }
        return $this;
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderNumber
     * @return \StructType\GetOrderStatusResult
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get parent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParent()
    {
        return isset($this->parent) ? $this->parent : null;
    }
    /**
     * Set parent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parent
     * @return \StructType\GetOrderStatusResult
     */
    public function setParent($parent = null)
    {
        // validation for constraint: string
        if (!is_null($parent) && !is_string($parent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parent, true), gettype($parent)), __LINE__);
        }
        if (is_null($parent) || (is_array($parent) && empty($parent))) {
            unset($this->parent);
        } else {
            $this->parent = $parent;
        }
        return $this;
    }
    /**
     * Get statusID value
     * @return int|null
     */
    public function getStatusID()
    {
        return $this->statusID;
    }
    /**
     * Set statusID value
     * @param int $statusID
     * @return \StructType\GetOrderStatusResult
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->statusID = $statusID;
        return $this;
    }
    /**
     * Get success value
     * @return bool|null
     */
    public function getSuccess()
    {
        return $this->success;
    }
    /**
     * Set success value
     * @param bool $success
     * @return \StructType\GetOrderStatusResult
     */
    public function setSuccess($success = null)
    {
        // validation for constraint: boolean
        if (!is_null($success) && !is_bool($success)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($success, true), gettype($success)), __LINE__);
        }
        $this->success = $success;
        return $this;
    }
}
