<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindOrderFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FindOrderFilter
 * @subpackage Structs
 */
class FindOrderFilter extends AbstractStructBase
{
    /**
     * The dEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dEnd;
    /**
     * The dStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dStart;
    /**
     * The orderNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $orderNumbers;
    /**
     * The statusList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $statusList;
    /**
     * The viewArchive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $viewArchive;
    /**
     * The warehouses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $warehouses;
    /**
     * Constructor method for FindOrderFilter
     * @uses FindOrderFilter::setDEnd()
     * @uses FindOrderFilter::setDStart()
     * @uses FindOrderFilter::setOrderNumbers()
     * @uses FindOrderFilter::setStatusList()
     * @uses FindOrderFilter::setViewArchive()
     * @uses FindOrderFilter::setWarehouses()
     * @param string $dEnd
     * @param string $dStart
     * @param \ArrayType\ArrayOfstring $orderNumbers
     * @param \ArrayType\ArrayOfint $statusList
     * @param bool $viewArchive
     * @param \ArrayType\ArrayOfint $warehouses
     */
    public function __construct($dEnd = null, $dStart = null, \ArrayType\ArrayOfstring $orderNumbers = null, \ArrayType\ArrayOfint $statusList = null, $viewArchive = null, \ArrayType\ArrayOfint $warehouses = null)
    {
        $this
            ->setDEnd($dEnd)
            ->setDStart($dStart)
            ->setOrderNumbers($orderNumbers)
            ->setStatusList($statusList)
            ->setViewArchive($viewArchive)
            ->setWarehouses($warehouses);
    }
    /**
     * Get dEnd value
     * @return string|null
     */
    public function getDEnd()
    {
        return $this->dEnd;
    }
    /**
     * Set dEnd value
     * @param string $dEnd
     * @return \StructType\FindOrderFilter
     */
    public function setDEnd($dEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dEnd) && !is_string($dEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEnd, true), gettype($dEnd)), __LINE__);
        }
        $this->dEnd = $dEnd;
        return $this;
    }
    /**
     * Get dStart value
     * @return string|null
     */
    public function getDStart()
    {
        return $this->dStart;
    }
    /**
     * Set dStart value
     * @param string $dStart
     * @return \StructType\FindOrderFilter
     */
    public function setDStart($dStart = null)
    {
        // validation for constraint: string
        if (!is_null($dStart) && !is_string($dStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dStart, true), gettype($dStart)), __LINE__);
        }
        $this->dStart = $dStart;
        return $this;
    }
    /**
     * Get orderNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOrderNumbers()
    {
        return isset($this->orderNumbers) ? $this->orderNumbers : null;
    }
    /**
     * Set orderNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $orderNumbers
     * @return \StructType\FindOrderFilter
     */
    public function setOrderNumbers(\ArrayType\ArrayOfstring $orderNumbers = null)
    {
        if (is_null($orderNumbers) || (is_array($orderNumbers) && empty($orderNumbers))) {
            unset($this->orderNumbers);
        } else {
            $this->orderNumbers = $orderNumbers;
        }
        return $this;
    }
    /**
     * Get statusList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getStatusList()
    {
        return isset($this->statusList) ? $this->statusList : null;
    }
    /**
     * Set statusList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $statusList
     * @return \StructType\FindOrderFilter
     */
    public function setStatusList(\ArrayType\ArrayOfint $statusList = null)
    {
        if (is_null($statusList) || (is_array($statusList) && empty($statusList))) {
            unset($this->statusList);
        } else {
            $this->statusList = $statusList;
        }
        return $this;
    }
    /**
     * Get viewArchive value
     * @return bool|null
     */
    public function getViewArchive()
    {
        return $this->viewArchive;
    }
    /**
     * Set viewArchive value
     * @param bool $viewArchive
     * @return \StructType\FindOrderFilter
     */
    public function setViewArchive($viewArchive = null)
    {
        // validation for constraint: boolean
        if (!is_null($viewArchive) && !is_bool($viewArchive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($viewArchive, true), gettype($viewArchive)), __LINE__);
        }
        $this->viewArchive = $viewArchive;
        return $this;
    }
    /**
     * Get warehouses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getWarehouses()
    {
        return isset($this->warehouses) ? $this->warehouses : null;
    }
    /**
     * Set warehouses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $warehouses
     * @return \StructType\FindOrderFilter
     */
    public function setWarehouses(\ArrayType\ArrayOfint $warehouses = null)
    {
        if (is_null($warehouses) || (is_array($warehouses) && empty($warehouses))) {
            unset($this->warehouses);
        } else {
            $this->warehouses = $warehouses;
        }
        return $this;
    }
}
