<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FindChangeOrderFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FindChangeOrderFilter
 * @subpackage Structs
 */
class FindChangeOrderFilter extends AbstractStructBase
{
    /**
     * The changed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $changed;
    /**
     * The userIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $userIDs;
    /**
     * The warehouses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $warehouses;
    /**
     * Constructor method for FindChangeOrderFilter
     * @uses FindChangeOrderFilter::setChanged()
     * @uses FindChangeOrderFilter::setUserIDs()
     * @uses FindChangeOrderFilter::setWarehouses()
     * @param string $changed
     * @param \ArrayType\ArrayOfint $userIDs
     * @param \ArrayType\ArrayOfint $warehouses
     */
    public function __construct($changed = null, \ArrayType\ArrayOfint $userIDs = null, \ArrayType\ArrayOfint $warehouses = null)
    {
        $this
            ->setChanged($changed)
            ->setUserIDs($userIDs)
            ->setWarehouses($warehouses);
    }
    /**
     * Get changed value
     * @return string|null
     */
    public function getChanged()
    {
        return $this->changed;
    }
    /**
     * Set changed value
     * @param string $changed
     * @return \StructType\FindChangeOrderFilter
     */
    public function setChanged($changed = null)
    {
        // validation for constraint: string
        if (!is_null($changed) && !is_string($changed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changed, true), gettype($changed)), __LINE__);
        }
        $this->changed = $changed;
        return $this;
    }
    /**
     * Get userIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getUserIDs()
    {
        return isset($this->userIDs) ? $this->userIDs : null;
    }
    /**
     * Set userIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $userIDs
     * @return \StructType\FindChangeOrderFilter
     */
    public function setUserIDs(\ArrayType\ArrayOfint $userIDs = null)
    {
        if (is_null($userIDs) || (is_array($userIDs) && empty($userIDs))) {
            unset($this->userIDs);
        } else {
            $this->userIDs = $userIDs;
        }
        return $this;
    }
    /**
     * Get warehouses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getWarehouses()
    {
        return isset($this->warehouses) ? $this->warehouses : null;
    }
    /**
     * Set warehouses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $warehouses
     * @return \StructType\FindChangeOrderFilter
     */
    public function setWarehouses(\ArrayType\ArrayOfint $warehouses = null)
    {
        if (is_null($warehouses) || (is_array($warehouses) && empty($warehouses))) {
            unset($this->warehouses);
        } else {
            $this->warehouses = $warehouses;
        }
        return $this;
    }
}
