<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangedOrder StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangedOrder
 * @subpackage Structs
 */
class ChangedOrder extends AbstractStructBase
{
    /**
     * The changed
     * @var string
     */
    public $changed;
    /**
     * The isArchive
     * @var bool
     */
    public $isArchive;
    /**
     * The orderDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderDate;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The productVersion
     * @var int
     */
    public $productVersion;
    /**
     * The serviceAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $serviceAccess;
    /**
     * The statusID
     * @var int
     */
    public $statusID;
    /**
     * The statusSatelliteID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $statusSatelliteID;
    /**
     * The userBusinessmanID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $userBusinessmanID;
    /**
     * The userID
     * @var int
     */
    public $userID;
    /**
     * Constructor method for ChangedOrder
     * @uses ChangedOrder::setChanged()
     * @uses ChangedOrder::setIsArchive()
     * @uses ChangedOrder::setOrderDate()
     * @uses ChangedOrder::setOrderNumber()
     * @uses ChangedOrder::setProductVersion()
     * @uses ChangedOrder::setServiceAccess()
     * @uses ChangedOrder::setStatusID()
     * @uses ChangedOrder::setStatusSatelliteID()
     * @uses ChangedOrder::setUserBusinessmanID()
     * @uses ChangedOrder::setUserID()
     * @param string $changed
     * @param bool $isArchive
     * @param string $orderDate
     * @param string $orderNumber
     * @param int $productVersion
     * @param int $serviceAccess
     * @param int $statusID
     * @param int $statusSatelliteID
     * @param int $userBusinessmanID
     * @param int $userID
     */
    public function __construct($changed = null, $isArchive = null, $orderDate = null, $orderNumber = null, $productVersion = null, $serviceAccess = null, $statusID = null, $statusSatelliteID = null, $userBusinessmanID = null, $userID = null)
    {
        $this
            ->setChanged($changed)
            ->setIsArchive($isArchive)
            ->setOrderDate($orderDate)
            ->setOrderNumber($orderNumber)
            ->setProductVersion($productVersion)
            ->setServiceAccess($serviceAccess)
            ->setStatusID($statusID)
            ->setStatusSatelliteID($statusSatelliteID)
            ->setUserBusinessmanID($userBusinessmanID)
            ->setUserID($userID);
    }
    /**
     * Get changed value
     * @return string|null
     */
    public function getChanged()
    {
        return $this->changed;
    }
    /**
     * Set changed value
     * @param string $changed
     * @return \StructType\ChangedOrder
     */
    public function setChanged($changed = null)
    {
        // validation for constraint: string
        if (!is_null($changed) && !is_string($changed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changed, true), gettype($changed)), __LINE__);
        }
        $this->changed = $changed;
        return $this;
    }
    /**
     * Get isArchive value
     * @return bool|null
     */
    public function getIsArchive()
    {
        return $this->isArchive;
    }
    /**
     * Set isArchive value
     * @param bool $isArchive
     * @return \StructType\ChangedOrder
     */
    public function setIsArchive($isArchive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isArchive) && !is_bool($isArchive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isArchive, true), gettype($isArchive)), __LINE__);
        }
        $this->isArchive = $isArchive;
        return $this;
    }
    /**
     * Get orderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->orderDate;
    }
    /**
     * Set orderDate value
     * @param string $orderDate
     * @return \StructType\ChangedOrder
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderDate, true), gettype($orderDate)), __LINE__);
        }
        $this->orderDate = $orderDate;
        return $this;
    }
    /**
     * Get orderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->orderNumber;
    }
    /**
     * Set orderNumber value
     * @param string $orderNumber
     * @return \StructType\ChangedOrder
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        $this->orderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get productVersion value
     * @return int|null
     */
    public function getProductVersion()
    {
        return $this->productVersion;
    }
    /**
     * Set productVersion value
     * @param int $productVersion
     * @return \StructType\ChangedOrder
     */
    public function setProductVersion($productVersion = null)
    {
        // validation for constraint: int
        if (!is_null($productVersion) && !(is_int($productVersion) || ctype_digit($productVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productVersion, true), gettype($productVersion)), __LINE__);
        }
        $this->productVersion = $productVersion;
        return $this;
    }
    /**
     * Get serviceAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getServiceAccess()
    {
        return isset($this->serviceAccess) ? $this->serviceAccess : null;
    }
    /**
     * Set serviceAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $serviceAccess
     * @return \StructType\ChangedOrder
     */
    public function setServiceAccess($serviceAccess = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAccess) && !(is_int($serviceAccess) || ctype_digit($serviceAccess))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceAccess, true), gettype($serviceAccess)), __LINE__);
        }
        if (is_null($serviceAccess) || (is_array($serviceAccess) && empty($serviceAccess))) {
            unset($this->serviceAccess);
        } else {
            $this->serviceAccess = $serviceAccess;
        }
        return $this;
    }
    /**
     * Get statusID value
     * @return int|null
     */
    public function getStatusID()
    {
        return $this->statusID;
    }
    /**
     * Set statusID value
     * @param int $statusID
     * @return \StructType\ChangedOrder
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->statusID = $statusID;
        return $this;
    }
    /**
     * Get statusSatelliteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStatusSatelliteID()
    {
        return isset($this->statusSatelliteID) ? $this->statusSatelliteID : null;
    }
    /**
     * Set statusSatelliteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $statusSatelliteID
     * @return \StructType\ChangedOrder
     */
    public function setStatusSatelliteID($statusSatelliteID = null)
    {
        // validation for constraint: int
        if (!is_null($statusSatelliteID) && !(is_int($statusSatelliteID) || ctype_digit($statusSatelliteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusSatelliteID, true), gettype($statusSatelliteID)), __LINE__);
        }
        if (is_null($statusSatelliteID) || (is_array($statusSatelliteID) && empty($statusSatelliteID))) {
            unset($this->statusSatelliteID);
        } else {
            $this->statusSatelliteID = $statusSatelliteID;
        }
        return $this;
    }
    /**
     * Get userBusinessmanID value
     * @return int|null
     */
    public function getUserBusinessmanID()
    {
        return $this->userBusinessmanID;
    }
    /**
     * Set userBusinessmanID value
     * @param int $userBusinessmanID
     * @return \StructType\ChangedOrder
     */
    public function setUserBusinessmanID($userBusinessmanID = null)
    {
        // validation for constraint: int
        if (!is_null($userBusinessmanID) && !(is_int($userBusinessmanID) || ctype_digit($userBusinessmanID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userBusinessmanID, true), gettype($userBusinessmanID)), __LINE__);
        }
        $this->userBusinessmanID = $userBusinessmanID;
        return $this;
    }
    /**
     * Get userID value
     * @return int|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param int $userID
     * @return \StructType\ChangedOrder
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
}
