<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Order ServiceType
 * @subpackage Services
 */
class Order extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named OrderReadyToWait
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OrderReadyToWait $parameters
     * @return \StructType\OrderReadyToWaitResponse|bool
     */
    public function OrderReadyToWait(\StructType\OrderReadyToWait $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->OrderReadyToWait($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OrderReadyToWaitResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
