<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfuserInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfuserInfo
 * @subpackage Arrays
 */
class ArrayOfuserInfo extends AbstractStructArrayBase
{
    /**
     * The userInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UserInfo[]
     */
    public $userInfo;
    /**
     * Constructor method for ArrayOfuserInfo
     * @uses ArrayOfuserInfo::setUserInfo()
     * @param \StructType\UserInfo[] $userInfo
     */
    public function __construct(array $userInfo = array())
    {
        $this
            ->setUserInfo($userInfo);
    }
    /**
     * Get userInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UserInfo[]|null
     */
    public function getUserInfo()
    {
        return isset($this->userInfo) ? $this->userInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUserInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUserInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUserInfoForArrayConstraintsFromSetUserInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfuserInfoUserInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfuserInfoUserInfoItem instanceof \StructType\UserInfo) {
                $invalidValues[] = is_object($arrayOfuserInfoUserInfoItem) ? get_class($arrayOfuserInfoUserInfoItem) : sprintf('%s(%s)', gettype($arrayOfuserInfoUserInfoItem), var_export($arrayOfuserInfoUserInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The userInfo property can only contain items of type \StructType\UserInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set userInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo[] $userInfo
     * @return \ArrayType\ArrayOfuserInfo
     */
    public function setUserInfo(array $userInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($userInfoArrayErrorMessage = self::validateUserInfoForArrayConstraintsFromSetUserInfo($userInfo))) {
            throw new \InvalidArgumentException($userInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($userInfo) || (is_array($userInfo) && empty($userInfo))) {
            unset($this->userInfo);
        } else {
            $this->userInfo = $userInfo;
        }
        return $this;
    }
    /**
     * Add item to userInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\UserInfo $item
     * @return \ArrayType\ArrayOfuserInfo
     */
    public function addToUserInfo(\StructType\UserInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserInfo) {
            throw new \InvalidArgumentException(sprintf('The userInfo property can only contain items of type \StructType\UserInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->userInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UserInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UserInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UserInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UserInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UserInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string userInfo
     */
    public function getAttributeName()
    {
        return 'userInfo';
    }
}
