<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfmovementInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfmovementInfo
 * @subpackage Arrays
 */
class ArrayOfmovementInfo extends AbstractStructArrayBase
{
    /**
     * The movementInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MovementInfo[]
     */
    public $movementInfo;
    /**
     * Constructor method for ArrayOfmovementInfo
     * @uses ArrayOfmovementInfo::setMovementInfo()
     * @param \StructType\MovementInfo[] $movementInfo
     */
    public function __construct(array $movementInfo = array())
    {
        $this
            ->setMovementInfo($movementInfo);
    }
    /**
     * Get movementInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MovementInfo[]|null
     */
    public function getMovementInfo()
    {
        return isset($this->movementInfo) ? $this->movementInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMovementInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMovementInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMovementInfoForArrayConstraintsFromSetMovementInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfmovementInfoMovementInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfmovementInfoMovementInfoItem instanceof \StructType\MovementInfo) {
                $invalidValues[] = is_object($arrayOfmovementInfoMovementInfoItem) ? get_class($arrayOfmovementInfoMovementInfoItem) : sprintf('%s(%s)', gettype($arrayOfmovementInfoMovementInfoItem), var_export($arrayOfmovementInfoMovementInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The movementInfo property can only contain items of type \StructType\MovementInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set movementInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MovementInfo[] $movementInfo
     * @return \ArrayType\ArrayOfmovementInfo
     */
    public function setMovementInfo(array $movementInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($movementInfoArrayErrorMessage = self::validateMovementInfoForArrayConstraintsFromSetMovementInfo($movementInfo))) {
            throw new \InvalidArgumentException($movementInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($movementInfo) || (is_array($movementInfo) && empty($movementInfo))) {
            unset($this->movementInfo);
        } else {
            $this->movementInfo = $movementInfo;
        }
        return $this;
    }
    /**
     * Add item to movementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\MovementInfo $item
     * @return \ArrayType\ArrayOfmovementInfo
     */
    public function addToMovementInfo(\StructType\MovementInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MovementInfo) {
            throw new \InvalidArgumentException(sprintf('The movementInfo property can only contain items of type \StructType\MovementInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->movementInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MovementInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MovementInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MovementInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MovementInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MovementInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string movementInfo
     */
    public function getAttributeName()
    {
        return 'movementInfo';
    }
}
