<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWarehouseInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfWarehouseInfo
 * @subpackage Arrays
 */
class ArrayOfWarehouseInfo extends AbstractStructArrayBase
{
    /**
     * The WarehouseInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WarehouseInfo[]
     */
    public $WarehouseInfo;
    /**
     * Constructor method for ArrayOfWarehouseInfo
     * @uses ArrayOfWarehouseInfo::setWarehouseInfo()
     * @param \StructType\WarehouseInfo[] $warehouseInfo
     */
    public function __construct(array $warehouseInfo = array())
    {
        $this
            ->setWarehouseInfo($warehouseInfo);
    }
    /**
     * Get WarehouseInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WarehouseInfo[]|null
     */
    public function getWarehouseInfo()
    {
        return isset($this->WarehouseInfo) ? $this->WarehouseInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWarehouseInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarehouseInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarehouseInfoForArrayConstraintsFromSetWarehouseInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWarehouseInfoWarehouseInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfWarehouseInfoWarehouseInfoItem instanceof \StructType\WarehouseInfo) {
                $invalidValues[] = is_object($arrayOfWarehouseInfoWarehouseInfoItem) ? get_class($arrayOfWarehouseInfoWarehouseInfoItem) : sprintf('%s(%s)', gettype($arrayOfWarehouseInfoWarehouseInfoItem), var_export($arrayOfWarehouseInfoWarehouseInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WarehouseInfo property can only contain items of type \StructType\WarehouseInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WarehouseInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseInfo[] $warehouseInfo
     * @return \ArrayType\ArrayOfWarehouseInfo
     */
    public function setWarehouseInfo(array $warehouseInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($warehouseInfoArrayErrorMessage = self::validateWarehouseInfoForArrayConstraintsFromSetWarehouseInfo($warehouseInfo))) {
            throw new \InvalidArgumentException($warehouseInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($warehouseInfo) || (is_array($warehouseInfo) && empty($warehouseInfo))) {
            unset($this->WarehouseInfo);
        } else {
            $this->WarehouseInfo = $warehouseInfo;
        }
        return $this;
    }
    /**
     * Add item to WarehouseInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\WarehouseInfo $item
     * @return \ArrayType\ArrayOfWarehouseInfo
     */
    public function addToWarehouseInfo(\StructType\WarehouseInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WarehouseInfo) {
            throw new \InvalidArgumentException(sprintf('The WarehouseInfo property can only contain items of type \StructType\WarehouseInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WarehouseInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WarehouseInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WarehouseInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WarehouseInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WarehouseInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WarehouseInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WarehouseInfo
     */
    public function getAttributeName()
    {
        return 'WarehouseInfo';
    }
}
