<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TireCalcSize StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TireCalcSize
 * @subpackage Structs
 */
class TireCalcSize extends AbstractStructBase
{
    /**
     * The diameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $diameter;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $height;
    /**
     * The outer_diameter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $outer_diameter;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $width;
    /**
     * Constructor method for TireCalcSize
     * @uses TireCalcSize::setDiameter()
     * @uses TireCalcSize::setHeight()
     * @uses TireCalcSize::setOuter_diameter()
     * @uses TireCalcSize::setWidth()
     * @param float $diameter
     * @param float $height
     * @param float $outer_diameter
     * @param float $width
     */
    public function __construct($diameter = null, $height = null, $outer_diameter = null, $width = null)
    {
        $this
            ->setDiameter($diameter)
            ->setHeight($height)
            ->setOuter_diameter($outer_diameter)
            ->setWidth($width);
    }
    /**
     * Get diameter value
     * @return float|null
     */
    public function getDiameter()
    {
        return $this->diameter;
    }
    /**
     * Set diameter value
     * @param float $diameter
     * @return \StructType\TireCalcSize
     */
    public function setDiameter($diameter = null)
    {
        // validation for constraint: float
        if (!is_null($diameter) && !(is_float($diameter) || is_numeric($diameter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($diameter, true), gettype($diameter)), __LINE__);
        }
        $this->diameter = $diameter;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \StructType\TireCalcSize
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get outer_diameter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getOuter_diameter()
    {
        return isset($this->outer_diameter) ? $this->outer_diameter : null;
    }
    /**
     * Set outer_diameter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $outer_diameter
     * @return \StructType\TireCalcSize
     */
    public function setOuter_diameter($outer_diameter = null)
    {
        // validation for constraint: float
        if (!is_null($outer_diameter) && !(is_float($outer_diameter) || is_numeric($outer_diameter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($outer_diameter, true), gettype($outer_diameter)), __LINE__);
        }
        if (is_null($outer_diameter) || (is_array($outer_diameter) && empty($outer_diameter))) {
            unset($this->outer_diameter);
        } else {
            $this->outer_diameter = $outer_diameter;
        }
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \StructType\TireCalcSize
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
}
