<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrderStatus StructType
 * @subpackage Structs
 */
class SetOrderStatus extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The statusID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $statusID;
    /**
     * Constructor method for SetOrderStatus
     * @uses SetOrderStatus::setLogin()
     * @uses SetOrderStatus::setPassword()
     * @uses SetOrderStatus::setOrderNumber()
     * @uses SetOrderStatus::setStatusID()
     * @param string $login
     * @param string $password
     * @param string $orderNumber
     * @param int $statusID
     */
    public function __construct($login = null, $password = null, $orderNumber = null, $statusID = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setOrderNumber($orderNumber)
            ->setStatusID($statusID);
    }
    /**
     * Get login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogin()
    {
        return isset($this->login) ? $this->login : null;
    }
    /**
     * Set login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $login
     * @return \StructType\SetOrderStatus
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->login);
        } else {
            $this->login = $login;
        }
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\SetOrderStatus
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderNumber
     * @return \StructType\SetOrderStatus
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get statusID value
     * @return int|null
     */
    public function getStatusID()
    {
        return $this->statusID;
    }
    /**
     * Set statusID value
     * @param int $statusID
     * @return \StructType\SetOrderStatus
     */
    public function setStatusID($statusID = null)
    {
        // validation for constraint: int
        if (!is_null($statusID) && !(is_int($statusID) || ctype_digit($statusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusID, true), gettype($statusID)), __LINE__);
        }
        $this->statusID = $statusID;
        return $this;
    }
}
