<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for saleInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:saleInfo
 * @subpackage Structs
 */
class SaleInfo extends AbstractStructBase
{
    /**
     * The saleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $saleId;
    /**
     * The saleText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $saleText;
    /**
     * Constructor method for saleInfo
     * @uses SaleInfo::setSaleId()
     * @uses SaleInfo::setSaleText()
     * @param int $saleId
     * @param string $saleText
     */
    public function __construct($saleId = null, $saleText = null)
    {
        $this
            ->setSaleId($saleId)
            ->setSaleText($saleText);
    }
    /**
     * Get saleId value
     * @return int|null
     */
    public function getSaleId()
    {
        return $this->saleId;
    }
    /**
     * Set saleId value
     * @param int $saleId
     * @return \StructType\SaleInfo
     */
    public function setSaleId($saleId = null)
    {
        // validation for constraint: int
        if (!is_null($saleId) && !(is_int($saleId) || ctype_digit($saleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($saleId, true), gettype($saleId)), __LINE__);
        }
        $this->saleId = $saleId;
        return $this;
    }
    /**
     * Get saleText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleText()
    {
        return isset($this->saleText) ? $this->saleText : null;
    }
    /**
     * Set saleText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleText
     * @return \StructType\SaleInfo
     */
    public function setSaleText($saleText = null)
    {
        // validation for constraint: string
        if (!is_null($saleText) && !is_string($saleText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleText, true), gettype($saleText)), __LINE__);
        }
        if (is_null($saleText) || (is_array($saleText) && empty($saleText))) {
            unset($this->saleText);
        } else {
            $this->saleText = $saleText;
        }
        return $this;
    }
}
