<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderComment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderComment
 * @subpackage Structs
 */
class OrderComment extends AbstractStructBase
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The createDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createDate;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The userID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $userID;
    /**
     * Constructor method for OrderComment
     * @uses OrderComment::setComment()
     * @uses OrderComment::setCreateDate()
     * @uses OrderComment::setOrderNumber()
     * @uses OrderComment::setUserID()
     * @param string $comment
     * @param string $createDate
     * @param string $orderNumber
     * @param int $userID
     */
    public function __construct($comment = null, $createDate = null, $orderNumber = null, $userID = null)
    {
        $this
            ->setComment($comment)
            ->setCreateDate($createDate)
            ->setOrderNumber($orderNumber)
            ->setUserID($userID);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \StructType\OrderComment
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\OrderComment
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderNumber
     * @return \StructType\OrderComment
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get userID value
     * @return int|null
     */
    public function getUserID()
    {
        return $this->userID;
    }
    /**
     * Set userID value
     * @param int $userID
     * @return \StructType\OrderComment
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->userID = $userID;
        return $this;
    }
}
