<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for movementFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:movementFilter
 * @subpackage Structs
 */
class MovementFilter extends AbstractStructBase
{
    /**
     * The dEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dEnd;
    /**
     * The dStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dStart;
    /**
     * The idStoreFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idStoreFrom;
    /**
     * The idStoreTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idStoreTo;
    /**
     * The number
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $number;
    /**
     * The statusId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $statusId;
    /**
     * Constructor method for movementFilter
     * @uses MovementFilter::setDEnd()
     * @uses MovementFilter::setDStart()
     * @uses MovementFilter::setIdStoreFrom()
     * @uses MovementFilter::setIdStoreTo()
     * @uses MovementFilter::setNumber()
     * @uses MovementFilter::setStatusId()
     * @param string $dEnd
     * @param string $dStart
     * @param int $idStoreFrom
     * @param int $idStoreTo
     * @param string $number
     * @param int $statusId
     */
    public function __construct($dEnd = null, $dStart = null, $idStoreFrom = null, $idStoreTo = null, $number = null, $statusId = null)
    {
        $this
            ->setDEnd($dEnd)
            ->setDStart($dStart)
            ->setIdStoreFrom($idStoreFrom)
            ->setIdStoreTo($idStoreTo)
            ->setNumber($number)
            ->setStatusId($statusId);
    }
    /**
     * Get dEnd value
     * @return string|null
     */
    public function getDEnd()
    {
        return $this->dEnd;
    }
    /**
     * Set dEnd value
     * @param string $dEnd
     * @return \StructType\MovementFilter
     */
    public function setDEnd($dEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dEnd) && !is_string($dEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEnd, true), gettype($dEnd)), __LINE__);
        }
        $this->dEnd = $dEnd;
        return $this;
    }
    /**
     * Get dStart value
     * @return string|null
     */
    public function getDStart()
    {
        return $this->dStart;
    }
    /**
     * Set dStart value
     * @param string $dStart
     * @return \StructType\MovementFilter
     */
    public function setDStart($dStart = null)
    {
        // validation for constraint: string
        if (!is_null($dStart) && !is_string($dStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dStart, true), gettype($dStart)), __LINE__);
        }
        $this->dStart = $dStart;
        return $this;
    }
    /**
     * Get idStoreFrom value
     * @return int|null
     */
    public function getIdStoreFrom()
    {
        return $this->idStoreFrom;
    }
    /**
     * Set idStoreFrom value
     * @param int $idStoreFrom
     * @return \StructType\MovementFilter
     */
    public function setIdStoreFrom($idStoreFrom = null)
    {
        // validation for constraint: int
        if (!is_null($idStoreFrom) && !(is_int($idStoreFrom) || ctype_digit($idStoreFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStoreFrom, true), gettype($idStoreFrom)), __LINE__);
        }
        $this->idStoreFrom = $idStoreFrom;
        return $this;
    }
    /**
     * Get idStoreTo value
     * @return int|null
     */
    public function getIdStoreTo()
    {
        return $this->idStoreTo;
    }
    /**
     * Set idStoreTo value
     * @param int $idStoreTo
     * @return \StructType\MovementFilter
     */
    public function setIdStoreTo($idStoreTo = null)
    {
        // validation for constraint: int
        if (!is_null($idStoreTo) && !(is_int($idStoreTo) || ctype_digit($idStoreTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStoreTo, true), gettype($idStoreTo)), __LINE__);
        }
        $this->idStoreTo = $idStoreTo;
        return $this;
    }
    /**
     * Get number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->number) ? $this->number : null;
    }
    /**
     * Set number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\MovementFilter
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->number);
        } else {
            $this->number = $number;
        }
        return $this;
    }
    /**
     * Get statusId value
     * @return int|null
     */
    public function getStatusId()
    {
        return $this->statusId;
    }
    /**
     * Set statusId value
     * @param int $statusId
     * @return \StructType\MovementFilter
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: int
        if (!is_null($statusId) && !(is_int($statusId) || ctype_digit($statusId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusId, true), gettype($statusId)), __LINE__);
        }
        $this->statusId = $statusId;
        return $this;
    }
}
