<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for good StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:good
 * @subpackage Structs
 */
class Good extends AbstractStructBase
{
    /**
     * The artikul
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikul;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * Constructor method for good
     * @uses Good::setArtikul()
     * @uses Good::setOrderNumber()
     * @uses Good::setPrice()
     * @uses Good::setQuantity()
     * @param string $artikul
     * @param string $orderNumber
     * @param float $price
     * @param int $quantity
     */
    public function __construct($artikul = null, $orderNumber = null, $price = null, $quantity = null)
    {
        $this
            ->setArtikul($artikul)
            ->setOrderNumber($orderNumber)
            ->setPrice($price)
            ->setQuantity($quantity);
    }
    /**
     * Get artikul value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikul()
    {
        return isset($this->artikul) ? $this->artikul : null;
    }
    /**
     * Set artikul value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikul
     * @return \StructType\Good
     */
    public function setArtikul($artikul = null)
    {
        // validation for constraint: string
        if (!is_null($artikul) && !is_string($artikul)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikul, true), gettype($artikul)), __LINE__);
        }
        if (is_null($artikul) || (is_array($artikul) && empty($artikul))) {
            unset($this->artikul);
        } else {
            $this->artikul = $artikul;
        }
        return $this;
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderNumber
     * @return \StructType\Good
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\Good
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\Good
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
}
