<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getAddressListFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:getAddressListFilter
 * @subpackage Structs
 */
class GetAddressListFilter extends AbstractStructBase
{
    /**
     * The addressIdList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $addressIdList;
    /**
     * The isDefaultAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isDefaultAddress;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $paymentType;
    /**
     * Constructor method for getAddressListFilter
     * @uses GetAddressListFilter::setAddressIdList()
     * @uses GetAddressListFilter::setIsDefaultAddress()
     * @uses GetAddressListFilter::setPaymentType()
     * @param \ArrayType\ArrayOfint $addressIdList
     * @param bool $isDefaultAddress
     * @param int $paymentType
     */
    public function __construct(\ArrayType\ArrayOfint $addressIdList = null, $isDefaultAddress = null, $paymentType = null)
    {
        $this
            ->setAddressIdList($addressIdList)
            ->setIsDefaultAddress($isDefaultAddress)
            ->setPaymentType($paymentType);
    }
    /**
     * Get addressIdList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getAddressIdList()
    {
        return isset($this->addressIdList) ? $this->addressIdList : null;
    }
    /**
     * Set addressIdList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $addressIdList
     * @return \StructType\GetAddressListFilter
     */
    public function setAddressIdList(\ArrayType\ArrayOfint $addressIdList = null)
    {
        if (is_null($addressIdList) || (is_array($addressIdList) && empty($addressIdList))) {
            unset($this->addressIdList);
        } else {
            $this->addressIdList = $addressIdList;
        }
        return $this;
    }
    /**
     * Get isDefaultAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefaultAddress()
    {
        return isset($this->isDefaultAddress) ? $this->isDefaultAddress : null;
    }
    /**
     * Set isDefaultAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefaultAddress
     * @return \StructType\GetAddressListFilter
     */
    public function setIsDefaultAddress($isDefaultAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultAddress) && !is_bool($isDefaultAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefaultAddress, true), gettype($isDefaultAddress)), __LINE__);
        }
        if (is_null($isDefaultAddress) || (is_array($isDefaultAddress) && empty($isDefaultAddress))) {
            unset($this->isDefaultAddress);
        } else {
            $this->isDefaultAddress = $isDefaultAddress;
        }
        return $this;
    }
    /**
     * Get paymentType value
     * @return int|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\GetAddressListFilter
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !(is_int($paymentType) || ctype_digit($paymentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
}
