<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryInfoContainer StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryInfoContainer
 * @subpackage Structs
 */
class DeliveryInfoContainer extends AbstractStructBase
{
    /**
     * The addressId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $addressId;
    /**
     * The building
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $building;
    /**
     * The building2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $building2;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $city;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $contact;
    /**
     * The deliveryData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeliveryDatePeriod
     */
    public $deliveryData;
    /**
     * The house
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $house;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $note;
    /**
     * The office
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $office;
    /**
     * The paymentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $paymentType;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $street;
    /**
     * The telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $telephone;
    /**
     * The coordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CoordinatesAsDouble
     */
    public $coordinates;
    /**
     * The consigneeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $consigneeId;
    /**
     * Constructor method for DeliveryInfoContainer
     * @uses DeliveryInfoContainer::setAddressId()
     * @uses DeliveryInfoContainer::setBuilding()
     * @uses DeliveryInfoContainer::setBuilding2()
     * @uses DeliveryInfoContainer::setCity()
     * @uses DeliveryInfoContainer::setContact()
     * @uses DeliveryInfoContainer::setDeliveryData()
     * @uses DeliveryInfoContainer::setHouse()
     * @uses DeliveryInfoContainer::setNote()
     * @uses DeliveryInfoContainer::setOffice()
     * @uses DeliveryInfoContainer::setPaymentType()
     * @uses DeliveryInfoContainer::setStreet()
     * @uses DeliveryInfoContainer::setTelephone()
     * @uses DeliveryInfoContainer::setCoordinates()
     * @uses DeliveryInfoContainer::setConsigneeId()
     * @param int $addressId
     * @param string $building
     * @param string $building2
     * @param string $city
     * @param string $contact
     * @param \StructType\DeliveryDatePeriod $deliveryData
     * @param string $house
     * @param string $note
     * @param string $office
     * @param int $paymentType
     * @param string $street
     * @param string $telephone
     * @param \StructType\CoordinatesAsDouble $coordinates
     * @param int $consigneeId
     */
    public function __construct($addressId = null, $building = null, $building2 = null, $city = null, $contact = null, \StructType\DeliveryDatePeriod $deliveryData = null, $house = null, $note = null, $office = null, $paymentType = null, $street = null, $telephone = null, \StructType\CoordinatesAsDouble $coordinates = null, $consigneeId = null)
    {
        $this
            ->setAddressId($addressId)
            ->setBuilding($building)
            ->setBuilding2($building2)
            ->setCity($city)
            ->setContact($contact)
            ->setDeliveryData($deliveryData)
            ->setHouse($house)
            ->setNote($note)
            ->setOffice($office)
            ->setPaymentType($paymentType)
            ->setStreet($street)
            ->setTelephone($telephone)
            ->setCoordinates($coordinates)
            ->setConsigneeId($consigneeId);
    }
    /**
     * Get addressId value
     * @return int|null
     */
    public function getAddressId()
    {
        return $this->addressId;
    }
    /**
     * Set addressId value
     * @param int $addressId
     * @return \StructType\DeliveryInfoContainer
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: int
        if (!is_null($addressId) && !(is_int($addressId) || ctype_digit($addressId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        $this->addressId = $addressId;
        return $this;
    }
    /**
     * Get building value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuilding()
    {
        return isset($this->building) ? $this->building : null;
    }
    /**
     * Set building value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $building
     * @return \StructType\DeliveryInfoContainer
     */
    public function setBuilding($building = null)
    {
        // validation for constraint: string
        if (!is_null($building) && !is_string($building)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building, true), gettype($building)), __LINE__);
        }
        if (is_null($building) || (is_array($building) && empty($building))) {
            unset($this->building);
        } else {
            $this->building = $building;
        }
        return $this;
    }
    /**
     * Get building2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuilding2()
    {
        return isset($this->building2) ? $this->building2 : null;
    }
    /**
     * Set building2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $building2
     * @return \StructType\DeliveryInfoContainer
     */
    public function setBuilding2($building2 = null)
    {
        // validation for constraint: string
        if (!is_null($building2) && !is_string($building2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($building2, true), gettype($building2)), __LINE__);
        }
        if (is_null($building2) || (is_array($building2) && empty($building2))) {
            unset($this->building2);
        } else {
            $this->building2 = $building2;
        }
        return $this;
    }
    /**
     * Get city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->city) ? $this->city : null;
    }
    /**
     * Set city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\DeliveryInfoContainer
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->city);
        } else {
            $this->city = $city;
        }
        return $this;
    }
    /**
     * Get contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContact()
    {
        return isset($this->contact) ? $this->contact : null;
    }
    /**
     * Set contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contact
     * @return \StructType\DeliveryInfoContainer
     */
    public function setContact($contact = null)
    {
        // validation for constraint: string
        if (!is_null($contact) && !is_string($contact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contact, true), gettype($contact)), __LINE__);
        }
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->contact);
        } else {
            $this->contact = $contact;
        }
        return $this;
    }
    /**
     * Get deliveryData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeliveryDatePeriod|null
     */
    public function getDeliveryData()
    {
        return isset($this->deliveryData) ? $this->deliveryData : null;
    }
    /**
     * Set deliveryData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DeliveryDatePeriod $deliveryData
     * @return \StructType\DeliveryInfoContainer
     */
    public function setDeliveryData(\StructType\DeliveryDatePeriod $deliveryData = null)
    {
        if (is_null($deliveryData) || (is_array($deliveryData) && empty($deliveryData))) {
            unset($this->deliveryData);
        } else {
            $this->deliveryData = $deliveryData;
        }
        return $this;
    }
    /**
     * Get house value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHouse()
    {
        return isset($this->house) ? $this->house : null;
    }
    /**
     * Set house value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $house
     * @return \StructType\DeliveryInfoContainer
     */
    public function setHouse($house = null)
    {
        // validation for constraint: string
        if (!is_null($house) && !is_string($house)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($house, true), gettype($house)), __LINE__);
        }
        if (is_null($house) || (is_array($house) && empty($house))) {
            unset($this->house);
        } else {
            $this->house = $house;
        }
        return $this;
    }
    /**
     * Get note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->note) ? $this->note : null;
    }
    /**
     * Set note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\DeliveryInfoContainer
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->note);
        } else {
            $this->note = $note;
        }
        return $this;
    }
    /**
     * Get office value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOffice()
    {
        return isset($this->office) ? $this->office : null;
    }
    /**
     * Set office value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $office
     * @return \StructType\DeliveryInfoContainer
     */
    public function setOffice($office = null)
    {
        // validation for constraint: string
        if (!is_null($office) && !is_string($office)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($office, true), gettype($office)), __LINE__);
        }
        if (is_null($office) || (is_array($office) && empty($office))) {
            unset($this->office);
        } else {
            $this->office = $office;
        }
        return $this;
    }
    /**
     * Get paymentType value
     * @return int|null
     */
    public function getPaymentType()
    {
        return $this->paymentType;
    }
    /**
     * Set paymentType value
     * @param int $paymentType
     * @return \StructType\DeliveryInfoContainer
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: int
        if (!is_null($paymentType) && !(is_int($paymentType) || ctype_digit($paymentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->paymentType = $paymentType;
        return $this;
    }
    /**
     * Get street value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreet()
    {
        return isset($this->street) ? $this->street : null;
    }
    /**
     * Set street value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $street
     * @return \StructType\DeliveryInfoContainer
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        if (is_null($street) || (is_array($street) && empty($street))) {
            unset($this->street);
        } else {
            $this->street = $street;
        }
        return $this;
    }
    /**
     * Get telephone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephone()
    {
        return isset($this->telephone) ? $this->telephone : null;
    }
    /**
     * Set telephone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephone
     * @return \StructType\DeliveryInfoContainer
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        if (is_null($telephone) || (is_array($telephone) && empty($telephone))) {
            unset($this->telephone);
        } else {
            $this->telephone = $telephone;
        }
        return $this;
    }
    /**
     * Get coordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CoordinatesAsDouble|null
     */
    public function getCoordinates()
    {
        return isset($this->coordinates) ? $this->coordinates : null;
    }
    /**
     * Set coordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CoordinatesAsDouble $coordinates
     * @return \StructType\DeliveryInfoContainer
     */
    public function setCoordinates(\StructType\CoordinatesAsDouble $coordinates = null)
    {
        if (is_null($coordinates) || (is_array($coordinates) && empty($coordinates))) {
            unset($this->coordinates);
        } else {
            $this->coordinates = $coordinates;
        }
        return $this;
    }
    /**
     * Get consigneeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConsigneeId()
    {
        return isset($this->consigneeId) ? $this->consigneeId : null;
    }
    /**
     * Set consigneeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $consigneeId
     * @return \StructType\DeliveryInfoContainer
     */
    public function setConsigneeId($consigneeId = null)
    {
        // validation for constraint: int
        if (!is_null($consigneeId) && !(is_int($consigneeId) || ctype_digit($consigneeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($consigneeId, true), gettype($consigneeId)), __LINE__);
        }
        if (is_null($consigneeId) || (is_array($consigneeId) && empty($consigneeId))) {
            unset($this->consigneeId);
        } else {
            $this->consigneeId = $consigneeId;
        }
        return $this;
    }
}
