<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurrencyRate StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CurrencyRate
 * @subpackage Structs
 */
class CurrencyRate extends AbstractStructBase
{
    /**
     * The charCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $charCode;
    /**
     * The nominal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $nominal;
    /**
     * The numCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numCode;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $value;
    /**
     * Constructor method for CurrencyRate
     * @uses CurrencyRate::setCharCode()
     * @uses CurrencyRate::setNominal()
     * @uses CurrencyRate::setNumCode()
     * @uses CurrencyRate::setValue()
     * @param string $charCode
     * @param int $nominal
     * @param int $numCode
     * @param float $value
     */
    public function __construct($charCode = null, $nominal = null, $numCode = null, $value = null)
    {
        $this
            ->setCharCode($charCode)
            ->setNominal($nominal)
            ->setNumCode($numCode)
            ->setValue($value);
    }
    /**
     * Get charCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCharCode()
    {
        return isset($this->charCode) ? $this->charCode : null;
    }
    /**
     * Set charCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $charCode
     * @return \StructType\CurrencyRate
     */
    public function setCharCode($charCode = null)
    {
        // validation for constraint: string
        if (!is_null($charCode) && !is_string($charCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charCode, true), gettype($charCode)), __LINE__);
        }
        if (is_null($charCode) || (is_array($charCode) && empty($charCode))) {
            unset($this->charCode);
        } else {
            $this->charCode = $charCode;
        }
        return $this;
    }
    /**
     * Get nominal value
     * @return int|null
     */
    public function getNominal()
    {
        return $this->nominal;
    }
    /**
     * Set nominal value
     * @param int $nominal
     * @return \StructType\CurrencyRate
     */
    public function setNominal($nominal = null)
    {
        // validation for constraint: int
        if (!is_null($nominal) && !(is_int($nominal) || ctype_digit($nominal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nominal, true), gettype($nominal)), __LINE__);
        }
        $this->nominal = $nominal;
        return $this;
    }
    /**
     * Get numCode value
     * @return int|null
     */
    public function getNumCode()
    {
        return $this->numCode;
    }
    /**
     * Set numCode value
     * @param int $numCode
     * @return \StructType\CurrencyRate
     */
    public function setNumCode($numCode = null)
    {
        // validation for constraint: int
        if (!is_null($numCode) && !(is_int($numCode) || ctype_digit($numCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numCode, true), gettype($numCode)), __LINE__);
        }
        $this->numCode = $numCode;
        return $this;
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\CurrencyRate
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
