<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateMovement StructType
 * @subpackage Structs
 */
class CreateMovement extends AbstractStructBase
{
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The idStoreFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idStoreFrom;
    /**
     * The idStoreTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idStoreTo;
    /**
     * The orderNumberList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $orderNumberList;
    /**
     * Constructor method for CreateMovement
     * @uses CreateMovement::setLogin()
     * @uses CreateMovement::setPassword()
     * @uses CreateMovement::setIdStoreFrom()
     * @uses CreateMovement::setIdStoreTo()
     * @uses CreateMovement::setOrderNumberList()
     * @param string $login
     * @param string $password
     * @param int $idStoreFrom
     * @param int $idStoreTo
     * @param \ArrayType\ArrayOfstring $orderNumberList
     */
    public function __construct($login = null, $password = null, $idStoreFrom = null, $idStoreTo = null, \ArrayType\ArrayOfstring $orderNumberList = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setIdStoreFrom($idStoreFrom)
            ->setIdStoreTo($idStoreTo)
            ->setOrderNumberList($orderNumberList);
    }
    /**
     * Get login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogin()
    {
        return isset($this->login) ? $this->login : null;
    }
    /**
     * Set login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $login
     * @return \StructType\CreateMovement
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->login);
        } else {
            $this->login = $login;
        }
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\CreateMovement
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get idStoreFrom value
     * @return int|null
     */
    public function getIdStoreFrom()
    {
        return $this->idStoreFrom;
    }
    /**
     * Set idStoreFrom value
     * @param int $idStoreFrom
     * @return \StructType\CreateMovement
     */
    public function setIdStoreFrom($idStoreFrom = null)
    {
        // validation for constraint: int
        if (!is_null($idStoreFrom) && !(is_int($idStoreFrom) || ctype_digit($idStoreFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStoreFrom, true), gettype($idStoreFrom)), __LINE__);
        }
        $this->idStoreFrom = $idStoreFrom;
        return $this;
    }
    /**
     * Get idStoreTo value
     * @return int|null
     */
    public function getIdStoreTo()
    {
        return $this->idStoreTo;
    }
    /**
     * Set idStoreTo value
     * @param int $idStoreTo
     * @return \StructType\CreateMovement
     */
    public function setIdStoreTo($idStoreTo = null)
    {
        // validation for constraint: int
        if (!is_null($idStoreTo) && !(is_int($idStoreTo) || ctype_digit($idStoreTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idStoreTo, true), gettype($idStoreTo)), __LINE__);
        }
        $this->idStoreTo = $idStoreTo;
        return $this;
    }
    /**
     * Get orderNumberList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOrderNumberList()
    {
        return isset($this->orderNumberList) ? $this->orderNumberList : null;
    }
    /**
     * Set orderNumberList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $orderNumberList
     * @return \StructType\CreateMovement
     */
    public function setOrderNumberList(\ArrayType\ArrayOfstring $orderNumberList = null)
    {
        if (is_null($orderNumberList) || (is_array($orderNumberList) && empty($orderNumberList))) {
            unset($this->orderNumberList);
        } else {
            $this->orderNumberList = $orderNumberList;
        }
        return $this;
    }
}
