<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseOrder StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BaseOrder
 * @subpackage Structs
 */
class BaseOrder extends AbstractStructBase
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $address;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $city;
    /**
     * The clientCreateBonus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientCreateBonus;
    /**
     * The clientID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientID;
    /**
     * The clientUseBonus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $clientUseBonus;
    /**
     * The comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $comment;
    /**
     * The deliveryType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $deliveryType;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $email;
    /**
     * The fio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fio;
    /**
     * The isMarketOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isMarketOrder;
    /**
     * The orderNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $orderNumber;
    /**
     * The payType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $payType;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $phone;
    /**
     * Constructor method for BaseOrder
     * @uses BaseOrder::setAddress()
     * @uses BaseOrder::setCity()
     * @uses BaseOrder::setClientCreateBonus()
     * @uses BaseOrder::setClientID()
     * @uses BaseOrder::setClientUseBonus()
     * @uses BaseOrder::setComment()
     * @uses BaseOrder::setDeliveryType()
     * @uses BaseOrder::setEmail()
     * @uses BaseOrder::setFio()
     * @uses BaseOrder::setIsMarketOrder()
     * @uses BaseOrder::setOrderNumber()
     * @uses BaseOrder::setPayType()
     * @uses BaseOrder::setPhone()
     * @param string $address
     * @param string $city
     * @param int $clientCreateBonus
     * @param int $clientID
     * @param int $clientUseBonus
     * @param string $comment
     * @param string $deliveryType
     * @param string $email
     * @param string $fio
     * @param bool $isMarketOrder
     * @param string $orderNumber
     * @param string $payType
     * @param string $phone
     */
    public function __construct($address = null, $city = null, $clientCreateBonus = null, $clientID = null, $clientUseBonus = null, $comment = null, $deliveryType = null, $email = null, $fio = null, $isMarketOrder = null, $orderNumber = null, $payType = null, $phone = null)
    {
        $this
            ->setAddress($address)
            ->setCity($city)
            ->setClientCreateBonus($clientCreateBonus)
            ->setClientID($clientID)
            ->setClientUseBonus($clientUseBonus)
            ->setComment($comment)
            ->setDeliveryType($deliveryType)
            ->setEmail($email)
            ->setFio($fio)
            ->setIsMarketOrder($isMarketOrder)
            ->setOrderNumber($orderNumber)
            ->setPayType($payType)
            ->setPhone($phone);
    }
    /**
     * Get address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->address) ? $this->address : null;
    }
    /**
     * Set address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\BaseOrder
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->address);
        } else {
            $this->address = $address;
        }
        return $this;
    }
    /**
     * Get city value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->city) ? $this->city : null;
    }
    /**
     * Set city value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\BaseOrder
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->city);
        } else {
            $this->city = $city;
        }
        return $this;
    }
    /**
     * Get clientCreateBonus value
     * @return int|null
     */
    public function getClientCreateBonus()
    {
        return $this->clientCreateBonus;
    }
    /**
     * Set clientCreateBonus value
     * @param int $clientCreateBonus
     * @return \StructType\BaseOrder
     */
    public function setClientCreateBonus($clientCreateBonus = null)
    {
        // validation for constraint: int
        if (!is_null($clientCreateBonus) && !(is_int($clientCreateBonus) || ctype_digit($clientCreateBonus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientCreateBonus, true), gettype($clientCreateBonus)), __LINE__);
        }
        $this->clientCreateBonus = $clientCreateBonus;
        return $this;
    }
    /**
     * Get clientID value
     * @return int|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param int $clientID
     * @return \StructType\BaseOrder
     */
    public function setClientID($clientID = null)
    {
        // validation for constraint: int
        if (!is_null($clientID) && !(is_int($clientID) || ctype_digit($clientID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientID, true), gettype($clientID)), __LINE__);
        }
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get clientUseBonus value
     * @return int|null
     */
    public function getClientUseBonus()
    {
        return $this->clientUseBonus;
    }
    /**
     * Set clientUseBonus value
     * @param int $clientUseBonus
     * @return \StructType\BaseOrder
     */
    public function setClientUseBonus($clientUseBonus = null)
    {
        // validation for constraint: int
        if (!is_null($clientUseBonus) && !(is_int($clientUseBonus) || ctype_digit($clientUseBonus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientUseBonus, true), gettype($clientUseBonus)), __LINE__);
        }
        $this->clientUseBonus = $clientUseBonus;
        return $this;
    }
    /**
     * Get comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->comment) ? $this->comment : null;
    }
    /**
     * Set comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \StructType\BaseOrder
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->comment);
        } else {
            $this->comment = $comment;
        }
        return $this;
    }
    /**
     * Get deliveryType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryType()
    {
        return isset($this->deliveryType) ? $this->deliveryType : null;
    }
    /**
     * Set deliveryType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryType
     * @return \StructType\BaseOrder
     */
    public function setDeliveryType($deliveryType = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryType) && !is_string($deliveryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryType, true), gettype($deliveryType)), __LINE__);
        }
        if (is_null($deliveryType) || (is_array($deliveryType) && empty($deliveryType))) {
            unset($this->deliveryType);
        } else {
            $this->deliveryType = $deliveryType;
        }
        return $this;
    }
    /**
     * Get email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->email) ? $this->email : null;
    }
    /**
     * Set email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\BaseOrder
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->email);
        } else {
            $this->email = $email;
        }
        return $this;
    }
    /**
     * Get fio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFio()
    {
        return isset($this->fio) ? $this->fio : null;
    }
    /**
     * Set fio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fio
     * @return \StructType\BaseOrder
     */
    public function setFio($fio = null)
    {
        // validation for constraint: string
        if (!is_null($fio) && !is_string($fio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fio, true), gettype($fio)), __LINE__);
        }
        if (is_null($fio) || (is_array($fio) && empty($fio))) {
            unset($this->fio);
        } else {
            $this->fio = $fio;
        }
        return $this;
    }
    /**
     * Get isMarketOrder value
     * @return bool|null
     */
    public function getIsMarketOrder()
    {
        return $this->isMarketOrder;
    }
    /**
     * Set isMarketOrder value
     * @param bool $isMarketOrder
     * @return \StructType\BaseOrder
     */
    public function setIsMarketOrder($isMarketOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMarketOrder) && !is_bool($isMarketOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMarketOrder, true), gettype($isMarketOrder)), __LINE__);
        }
        $this->isMarketOrder = $isMarketOrder;
        return $this;
    }
    /**
     * Get orderNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderNumber()
    {
        return isset($this->orderNumber) ? $this->orderNumber : null;
    }
    /**
     * Set orderNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderNumber
     * @return \StructType\BaseOrder
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderNumber, true), gettype($orderNumber)), __LINE__);
        }
        if (is_null($orderNumber) || (is_array($orderNumber) && empty($orderNumber))) {
            unset($this->orderNumber);
        } else {
            $this->orderNumber = $orderNumber;
        }
        return $this;
    }
    /**
     * Get payType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayType()
    {
        return isset($this->payType) ? $this->payType : null;
    }
    /**
     * Set payType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payType
     * @return \StructType\BaseOrder
     */
    public function setPayType($payType = null)
    {
        // validation for constraint: string
        if (!is_null($payType) && !is_string($payType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payType, true), gettype($payType)), __LINE__);
        }
        if (is_null($payType) || (is_array($payType) && empty($payType))) {
            unset($this->payType);
        } else {
            $this->payType = $payType;
        }
        return $this;
    }
    /**
     * Get phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->phone) ? $this->phone : null;
    }
    /**
     * Set phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \StructType\BaseOrder
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->phone);
        } else {
            $this->phone = $phone;
        }
        return $this;
    }
}
