<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Propose ServiceType
 * @subpackage Services
 */
class Propose extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProposeGoods
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProposeGoods $parameters
     * @return \StructType\ProposeGoodsResponse|bool
     */
    public function ProposeGoods(\StructType\ProposeGoods $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProposeGoods($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProposeGoodsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
