<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetFindTyre
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFindTyre $parameters
     * @return \StructType\GetFindTyreResponse|bool
     */
    public function GetFindTyre(\StructType\GetFindTyre $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFindTyre($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFindDisk
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFindDisk $parameters
     * @return \StructType\GetFindDiskResponse|bool
     */
    public function GetFindDisk(\StructType\GetFindDisk $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFindDisk($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGoodsPriceRestByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGoodsPriceRestByCode $parameters
     * @return \StructType\GetGoodsPriceRestByCodeResponse|bool
     */
    public function GetGoodsPriceRestByCode(\StructType\GetGoodsPriceRestByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGoodsPriceRestByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGoodsInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGoodsInfo $parameters
     * @return \StructType\GetGoodsInfoResponse|bool
     */
    public function GetGoodsInfo(\StructType\GetGoodsInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGoodsInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGoodsByCar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGoodsByCar $parameters
     * @return \StructType\GetGoodsByCarResponse|bool
     */
    public function GetGoodsByCar(\StructType\GetGoodsByCar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetGoodsByCar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMarkaAvto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMarkaAvto $parameters
     * @return \StructType\GetMarkaAvtoResponse|bool
     */
    public function GetMarkaAvto(\StructType\GetMarkaAvto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMarkaAvto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetModelAvto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModelAvto $parameters
     * @return \StructType\GetModelAvtoResponse|bool
     */
    public function GetModelAvto(\StructType\GetModelAvto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetModelAvto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetYearAvto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetYearAvto $parameters
     * @return \StructType\GetYearAvtoResponse|bool
     */
    public function GetYearAvto(\StructType\GetYearAvto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetYearAvto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetModificationAvto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModificationAvto $parameters
     * @return \StructType\GetModificationAvtoResponse|bool
     */
    public function GetModificationAvto(\StructType\GetModificationAvto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetModificationAvto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetChangeOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetChangeOrder $parameters
     * @return \StructType\GetChangeOrderResponse|bool
     */
    public function GetChangeOrder(\StructType\GetChangeOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetChangeOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderStatus $parameters
     * @return \StructType\GetOrderStatusResponse|bool
     */
    public function GetOrderStatus(\StructType\GetOrderStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderInfo $parameters
     * @return \StructType\GetOrderInfoResponse|bool
     */
    public function GetOrderInfo(\StructType\GetOrderInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetStatusList $parameters
     * @return \StructType\GetStatusListResponse|bool
     */
    public function GetStatusList(\StructType\GetStatusList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetStatusList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderComment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOrderComment $parameters
     * @return \StructType\GetOrderCommentResponse|bool
     */
    public function GetOrderComment(\StructType\GetOrderComment $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderComment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserList $parameters
     * @return \StructType\GetUserListResponse|bool
     */
    public function GetUserList(\StructType\GetUserList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWarehouses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWarehouses $parameters
     * @return \StructType\GetWarehousesResponse|bool
     */
    public function GetWarehouses(\StructType\GetWarehouses $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWarehouses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPressureSensor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPressureSensor $parameters
     * @return \StructType\GetPressureSensorResponse|bool
     */
    public function GetPressureSensor(\StructType\GetPressureSensor $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPressureSensor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMovementList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMovementList $parameters
     * @return \StructType\GetMovementListResponse|bool
     */
    public function GetMovementList(\StructType\GetMovementList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMovementList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMovementInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMovementInfo $parameters
     * @return \StructType\GetMovementInfoResponse|bool
     */
    public function GetMovementInfo(\StructType\GetMovementInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMovementInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFastener
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFastener $parameters
     * @return \StructType\GetFastenerResponse|bool
     */
    public function GetFastener(\StructType\GetFastener $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetFastener($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAddressList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAddressList $parameters
     * @return \StructType\GetAddressListResponse|bool
     */
    public function GetAddressList(\StructType\GetAddressList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAddressList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryPeriod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDeliveryPeriod $parameters
     * @return \StructType\GetDeliveryPeriodResponse|bool
     */
    public function GetDeliveryPeriod(\StructType\GetDeliveryPeriod $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryPeriod($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSaleInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaleInfo $parameters
     * @return \StructType\GetSaleInfoResponse|bool
     */
    public function GetSaleInfo(\StructType\GetSaleInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSaleInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSaleList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSaleList $parameters
     * @return \StructType\GetSaleListResponse|bool
     */
    public function GetSaleList(\StructType\GetSaleList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSaleList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConsumable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConsumable $parameters
     * @return \StructType\GetConsumableResponse|bool
     */
    public function GetConsumable(\StructType\GetConsumable $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConsumable($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConsigneeList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConsigneeList $parameters
     * @return \StructType\GetConsigneeListResponse|bool
     */
    public function GetConsigneeList(\StructType\GetConsigneeList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetConsigneeList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAddressListResponse|\StructType\GetChangeOrderResponse|\StructType\GetConsigneeListResponse|\StructType\GetConsumableResponse|\StructType\GetDeliveryPeriodResponse|\StructType\GetFastenerResponse|\StructType\GetFindDiskResponse|\StructType\GetFindTyreResponse|\StructType\GetGoodsByCarResponse|\StructType\GetGoodsInfoResponse|\StructType\GetGoodsPriceRestByCodeResponse|\StructType\GetMarkaAvtoResponse|\StructType\GetModelAvtoResponse|\StructType\GetModificationAvtoResponse|\StructType\GetMovementInfoResponse|\StructType\GetMovementListResponse|\StructType\GetOrderCommentResponse|\StructType\GetOrderInfoResponse|\StructType\GetOrderStatusResponse|\StructType\GetPressureSensorResponse|\StructType\GetSaleInfoResponse|\StructType\GetSaleListResponse|\StructType\GetStatusListResponse|\StructType\GetUserListResponse|\StructType\GetWarehousesResponse|\StructType\GetYearAvtoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
