<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfnote ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfnote
 * @subpackage Arrays
 */
class ArrayOfnote extends AbstractStructArrayBase
{
    /**
     * The note
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Note[]
     */
    public $note;
    /**
     * Constructor method for ArrayOfnote
     * @uses ArrayOfnote::setNote()
     * @param \StructType\Note[] $note
     */
    public function __construct(array $note = array())
    {
        $this
            ->setNote($note);
    }
    /**
     * Get note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Note[]|null
     */
    public function getNote()
    {
        return isset($this->note) ? $this->note : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNote method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNote method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNoteForArrayConstraintsFromSetNote(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfnoteNoteItem) {
            // validation for constraint: itemType
            if (!$arrayOfnoteNoteItem instanceof \StructType\Note) {
                $invalidValues[] = is_object($arrayOfnoteNoteItem) ? get_class($arrayOfnoteNoteItem) : sprintf('%s(%s)', gettype($arrayOfnoteNoteItem), var_export($arrayOfnoteNoteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The note property can only contain items of type \StructType\Note, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Note[] $note
     * @return \ArrayType\ArrayOfnote
     */
    public function setNote(array $note = array())
    {
        // validation for constraint: array
        if ('' !== ($noteArrayErrorMessage = self::validateNoteForArrayConstraintsFromSetNote($note))) {
            throw new \InvalidArgumentException($noteArrayErrorMessage, __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->note);
        } else {
            $this->note = $note;
        }
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param \StructType\Note $item
     * @return \ArrayType\ArrayOfnote
     */
    public function addToNote(\StructType\Note $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Note) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of type \StructType\Note, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Note|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Note|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Note|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Note|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Note|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string note
     */
    public function getAttributeName()
    {
        return 'note';
    }
}
