<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderProduct ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOrderProduct
 * @subpackage Arrays
 */
class ArrayOfOrderProduct extends AbstractStructArrayBase
{
    /**
     * The OrderProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderProduct[]
     */
    public $OrderProduct;
    /**
     * Constructor method for ArrayOfOrderProduct
     * @uses ArrayOfOrderProduct::setOrderProduct()
     * @param \StructType\OrderProduct[] $orderProduct
     */
    public function __construct(array $orderProduct = array())
    {
        $this
            ->setOrderProduct($orderProduct);
    }
    /**
     * Get OrderProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderProduct[]|null
     */
    public function getOrderProduct()
    {
        return isset($this->OrderProduct) ? $this->OrderProduct : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderProductForArrayConstraintsFromSetOrderProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderProductOrderProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderProductOrderProductItem instanceof \StructType\OrderProduct) {
                $invalidValues[] = is_object($arrayOfOrderProductOrderProductItem) ? get_class($arrayOfOrderProductOrderProductItem) : sprintf('%s(%s)', gettype($arrayOfOrderProductOrderProductItem), var_export($arrayOfOrderProductOrderProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderProduct property can only contain items of type \StructType\OrderProduct, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderProduct[] $orderProduct
     * @return \ArrayType\ArrayOfOrderProduct
     */
    public function setOrderProduct(array $orderProduct = array())
    {
        // validation for constraint: array
        if ('' !== ($orderProductArrayErrorMessage = self::validateOrderProductForArrayConstraintsFromSetOrderProduct($orderProduct))) {
            throw new \InvalidArgumentException($orderProductArrayErrorMessage, __LINE__);
        }
        if (is_null($orderProduct) || (is_array($orderProduct) && empty($orderProduct))) {
            unset($this->OrderProduct);
        } else {
            $this->OrderProduct = $orderProduct;
        }
        return $this;
    }
    /**
     * Add item to OrderProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderProduct $item
     * @return \ArrayType\ArrayOfOrderProduct
     */
    public function addToOrderProduct(\StructType\OrderProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderProduct) {
            throw new \InvalidArgumentException(sprintf('The OrderProduct property can only contain items of type \StructType\OrderProduct, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderProduct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderProduct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderProduct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderProduct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderProduct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderProduct
     */
    public function getAttributeName()
    {
        return 'OrderProduct';
    }
}
