<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderComment ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOrderComment
 * @subpackage Arrays
 */
class ArrayOfOrderComment extends AbstractStructArrayBase
{
    /**
     * The OrderComment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderComment[]
     */
    public $OrderComment;
    /**
     * Constructor method for ArrayOfOrderComment
     * @uses ArrayOfOrderComment::setOrderComment()
     * @param \StructType\OrderComment[] $orderComment
     */
    public function __construct(array $orderComment = array())
    {
        $this
            ->setOrderComment($orderComment);
    }
    /**
     * Get OrderComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderComment[]|null
     */
    public function getOrderComment()
    {
        return isset($this->OrderComment) ? $this->OrderComment : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderComment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderComment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderCommentForArrayConstraintsFromSetOrderComment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderCommentOrderCommentItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderCommentOrderCommentItem instanceof \StructType\OrderComment) {
                $invalidValues[] = is_object($arrayOfOrderCommentOrderCommentItem) ? get_class($arrayOfOrderCommentOrderCommentItem) : sprintf('%s(%s)', gettype($arrayOfOrderCommentOrderCommentItem), var_export($arrayOfOrderCommentOrderCommentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderComment property can only contain items of type \StructType\OrderComment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderComment[] $orderComment
     * @return \ArrayType\ArrayOfOrderComment
     */
    public function setOrderComment(array $orderComment = array())
    {
        // validation for constraint: array
        if ('' !== ($orderCommentArrayErrorMessage = self::validateOrderCommentForArrayConstraintsFromSetOrderComment($orderComment))) {
            throw new \InvalidArgumentException($orderCommentArrayErrorMessage, __LINE__);
        }
        if (is_null($orderComment) || (is_array($orderComment) && empty($orderComment))) {
            unset($this->OrderComment);
        } else {
            $this->OrderComment = $orderComment;
        }
        return $this;
    }
    /**
     * Add item to OrderComment value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderComment $item
     * @return \ArrayType\ArrayOfOrderComment
     */
    public function addToOrderComment(\StructType\OrderComment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderComment) {
            throw new \InvalidArgumentException(sprintf('The OrderComment property can only contain items of type \StructType\OrderComment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderComment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderComment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderComment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderComment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderComment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderComment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderComment
     */
    public function getAttributeName()
    {
        return 'OrderComment';
    }
}
