<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGoods ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfGoods
 * @subpackage Arrays
 */
class ArrayOfGoods extends AbstractStructArrayBase
{
    /**
     * The Goods
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Goods[]
     */
    public $Goods;
    /**
     * Constructor method for ArrayOfGoods
     * @uses ArrayOfGoods::setGoods()
     * @param \StructType\Goods[] $goods
     */
    public function __construct(array $goods = array())
    {
        $this
            ->setGoods($goods);
    }
    /**
     * Get Goods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Goods[]|null
     */
    public function getGoods()
    {
        return isset($this->Goods) ? $this->Goods : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGoods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsForArrayConstraintsFromSetGoods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfGoodsGoodsItem) {
            // validation for constraint: itemType
            if (!$arrayOfGoodsGoodsItem instanceof \StructType\Goods) {
                $invalidValues[] = is_object($arrayOfGoodsGoodsItem) ? get_class($arrayOfGoodsGoodsItem) : sprintf('%s(%s)', gettype($arrayOfGoodsGoodsItem), var_export($arrayOfGoodsGoodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Goods property can only contain items of type \StructType\Goods, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Goods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Goods[] $goods
     * @return \ArrayType\ArrayOfGoods
     */
    public function setGoods(array $goods = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsArrayErrorMessage = self::validateGoodsForArrayConstraintsFromSetGoods($goods))) {
            throw new \InvalidArgumentException($goodsArrayErrorMessage, __LINE__);
        }
        if (is_null($goods) || (is_array($goods) && empty($goods))) {
            unset($this->Goods);
        } else {
            $this->Goods = $goods;
        }
        return $this;
    }
    /**
     * Add item to Goods value
     * @throws \InvalidArgumentException
     * @param \StructType\Goods $item
     * @return \ArrayType\ArrayOfGoods
     */
    public function addToGoods(\StructType\Goods $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Goods) {
            throw new \InvalidArgumentException(sprintf('The Goods property can only contain items of type \StructType\Goods, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Goods[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Goods|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Goods|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Goods|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Goods|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Goods|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Goods
     */
    public function getAttributeName()
    {
        return 'Goods';
    }
}
